package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;

/**
 ******************************************************************************
 **
 **  Contains the description of a monitoring data channel
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class MonitorChan implements Serializable {

    private String name, description, format, units, lowAlarm, highAlarm;
    private double lowLimit, highLimit, value;


    public MonitorChan(String name, String description, String format,
                       String units, double lowLimit, String lowAlarm,
                       double highLimit, String highAlarm, double value) {
        this.name = name;
        this.description = description;
        this.format = format;
        this.units = units;
        this.lowLimit = lowLimit;
        this.lowAlarm = lowAlarm;
        this.highLimit = highLimit;
        this.highAlarm = highAlarm;
        this.value = value;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setHighAlarm(String highAlarm) {
        this.highAlarm = highAlarm;
    }

    public void setHighLimit(double highLimit) {
        this.highLimit = highLimit;
    }

    public void setLowAlarm(String lowAlarm) {
        this.lowAlarm = lowAlarm;
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public String getFormat() {
        return format;
    }

    public String getHighAlarm() {
        return highAlarm;
    }

    public double getHighLimit() {
        return highLimit;
    }

    public String getLowAlarm() {
        return lowAlarm;
    }

    public double getLowLimit() {
        return lowLimit;
    }

    public String getName() {
        return name;
    }

    public String getUnits() {
        return units;
    }

    public double getValue() {
        return value;
    }

    private static final long serialVersionUID = -7199421177953484510L;
}
