package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains information describing the full monitor-only system state.
 **
 **  Sent on the status bus upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MonMainFullState implements Serializable {

    private final MonMainState monMainState;
    private final MonitorFullState monitorState;

    public MonMainFullState(MonMainState mmState, MonitorFullState mfState) {
        monMainState = mmState;
        monitorState = mfState;
    }

    public MonMainState getMonMainState() {
        return monMainState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

}
