package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 ******************************************************************************
 **
 **  Contains information describing the full monitoring state.
 **
 **  Sent on the status bus upon startup or upon request.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class MonitorFullState implements Serializable {

    private static final long serialVersionUID = 5573826753628650396L;

    private final List<MonitorChan> channels = new ArrayList<>();
    private final Map<String, String> alarms = new HashMap<>();
    private MonitorState monState;

    public void addAlarm(String name, String description) {
        alarms.put(name, description);
    }
    
    public Map<String, String> getAlarms() {
        return alarms;
    }
    
    public void addChannel(MonitorChan chan) {
        channels.add(chan);
    }
    
    public List<MonitorChan> getChannels() {
        return channels;
    }
    
    public void setMonitorState(MonitorState state) {
        monState = state;
    }

    public MonitorState getMonitorState() {
        return monState;
    }

}
