package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 ***************************************************************************
 **
 **  Contains information describing the full monitoring state.
 **
 **  Sent on the status bus upon startup or upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MonitorFullState implements Serializable {

    private static final long serialVersionUID = -3849053573942731218L;

    private List<MonitorChan> channels = new ArrayList<>();
    private MonitorState monState;

    public void addChannel(MonitorChan chan) {
        channels.add(chan);
    }
    
    public List<MonitorChan> getChannels() {
        return channels;
    }
    
    public void setMonitorState(MonitorState state) {
        monState = state;
    }

    public MonitorState getMonitorState() {
        return monState;
    }

}
