package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the description of a monitoring data channel
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MonitorChan implements Serializable {

    private static final long serialVersionUID = 5612166507206743353L;

    private String name, description, units;
    private double lowLimit, highLimit, value;


    public MonitorChan(String name, String description, String units,
                       double lowLimit, double highLimit, double value) {
        this.name = name;
        this.description = description;
        this.units = units;
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
        this.value = value;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

    public void setHighLimit(double highLimit) {
        this.highLimit = highLimit;
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public double getHighLimit() {
        return highLimit;
    }

    public double getLowLimit() {
        return lowLimit;
    }

    public String getName() {
        return name;
    }

    public String getUnits() {
        return units;
    }

    public double getValue() {
        return value;
    }
    
}
