import org.lsst.ccs.description.groovy.CCSBuilder;

import org.lsst.ccs.subsystem.common.devices.turbopump.*;
import org.lsst.ccs.subsystem.common.devices.refrigeration.*;
import org.lsst.ccs.subsystem.common.devices.refrigeration.data.RefrigerationConfig
import org.lsst.ccs.subsystem.common.devices.vacuum.*;
import org.lsst.ccs.subsystem.common.devices.power.distribution.*;

import org.lsst.ccs.subsystem.comcamvacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.comcamvacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.comcamvacuum.IonPumpControl;
//import org.lsst.ccs.subsystem.comcamvacuum.CryoTurboDevice;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacSysState;


import org.lsst.ccs.subsystem.comcamvacuum.data.*;
import org.lsst.ccs.subsystem.comcamvacuum.*;
import org.lsst.ccs.subsystem.comcamvacuum.alerts.ComCamVacuumAlerts;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["comcam-vacuum"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

//Class turboClass = Class.forName("org.lsst.ccs.common.devices.turbopump.TwisTorr84" + "Device");

taskConfig = ["monitor-update/taskPeriodMillis":3000,"monitor-publish/taskPeriodMillis":3000]

builder.

    main (ComCamVacuumSubsystem, nodeTags:taskConfig, cryoPressChan:"VQMonitor/vqmpressure", turboPressChan:"VQMonitor/vqmpressure",
              turboSpeedChan:"turbo/rpm",
        switches:[VacSysState.SW_CRYO_TURBO, VacSysState.SW_CRYO_ION_PUMP1, VacSysState.SW_CRYO_VALVE,
                    VacSysState.SW_CRYOTEL_CRYO, VacSysState.SW_CRYOTEL_COLD1, VacSysState.SW_CRYOTEL_COLD2]) {
//                    VacSysState.SW_KOOLANCE, VacSysState.SW_KOOLCOLD, VacSysState.SW_CRYOTEL_CRYO, VacSysState.SW_CRYOTEL_COLD1, VacSysState.SW_CRYOTEL_COLD2,

    ComCamVacuumAlertHandler (ComCamVacuumAlertHandler)


    AlarmCryoHighTempLimit  (Alarm, description:"Cryo Plate high temperature alarm", eventParm:ComCamVacuumAlerts.CRYO_PLATE_TEMPERATURE_TOO_HIGH.ordinal())

    AlarmCryoLowTempLimit   (Alarm, description:"Cryo Plate low temperature alarm", eventParm:ComCamVacuumAlerts.CRYO_PLATE_TEMPERATURE_TOO_LOW.ordinal())
    
    AlarmColdHighTempLimit  (Alarm, description:"Cold Plate high temperature alarm", eventParm:ComCamVacuumAlerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.ordinal())

    AlarmColdLowTempLimit   (Alarm, description:"Cold Plate low temperature alarm", eventParm:ComCamVacuumAlerts.COLD_PLATE_TEMPERATURE_TOO_LOW.ordinal())

    AlarmPressureHighLimit  (Alarm, description:"Pressure too high alarm", eventParm:ComCamVacuumAlerts.PRESSURE_TOO_HIGH.ordinal())

    AlarmPressureLowLimit   (Alarm, description:"Pressure too low alarm", eventParm:ComCamVacuumAlerts.PRESSURE_TOO_LOW.ordinal())

    AlarmTurboStatusFail    (Alarm, description:"Turbo Pump Status = Fail", eventParm:ComCamVacuumAlerts.TURBO_PUMP_FAIL.ordinal())

    AlarmTurboTempHighLimit (Alarm, description:"Turbo Pump Temp too high", eventParm:ComCamVacuumAlerts.TURBO_PUMP_OVERTEMP.ordinal())

    AlarmGeneric  (Alarm, description:"Generic alarm", eventParm:ComCamVacuumAlerts.GENERIC.ordinal())

//    AlarmHDWC  (Alarm, eventParm:ComCamVacuumConfig.EVENT_ID.CRYO.ordinal())
    AlarmHDWC  (Alarm, description:"Cold Plate high temperature alarm", eventParm:ComCamVacuumAlerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.ordinal())


    cryo  (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A107I7UW-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.CRYO) {

        "temperature"  (Channel,
                    description:"Cooler temperature", units:"\u00b0C",
                           hwChan:0, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        "setpoint"  (Channel,
                    description:"Cooler setpoint temperature", units:"\u00b0C",
                           hwChan:1, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        "setPower"  (Channel,
                    description:"Cooler power setting", units:"Watt",
                           hwChan:2, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:60.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "power"  (Channel,
                    description:"Cooler power", units:"Watt",
                           hwChan:3, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:250.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOffEnabled"  (Channel,
                    description:"Cooler auto shutoff state (1 = auto off)", units:"unitless",
                           hwChan:4, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOffTemperature"  (Channel,
                    description:"Cooler auto shutoff temperature setting", units:"\u00b0C",
                           hwChan:5, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOnTemperature"  (Channel,
                    description:"Cooler auto shutoff cancellation temperature setting", units:"\u00b0C",
                           hwChan:6, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "rejectTemperature"  (Channel,
                    description:"Cooler reject temperature reading", units:"\u00b0C",
                           hwChan:7, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

    }

//    CryoTelCold1 (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A107I7UU-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.COLD1)
    cold1 (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A105QFTR-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.COLD1) {

        "temperature"  (Channel,
                    description:"Cooler temperature", units:"\u00b0C",
                           hwChan:0, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "setpoint"  (Channel,
                    description:"Cooler setpoint temperature", units:"\u00b0C",
                           hwChan:1, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        "setPower"  (Channel,
                    description:"Cooler power setting", units:"Watt",
                           hwChan:2, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:250.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "power"  (Channel,
                    description:"Cooler power", units:"Watt",
                           hwChan:3, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:60.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOffEnabled"  (Channel,
                    description:"Cooler auto shutoff state (1 = auto off)", units:"unitless",
                           hwChan:4, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOffTemperature"  (Channel,
                    description:"Cooler auto shutoff temperature setting", units:"\u00b0C",
                           hwChan:5, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOnTemperature"  (Channel,
                    description:"Cooler auto shutoff cancellation temperature setting", units:"\u00b0C",
                           hwChan:6, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "rejectTemperature"  (Channel,
                    description:"Cooler reject temperature reading", units:"\u00b0C",
                           hwChan:7, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

    }

//    CryoTelCold2 (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A107I7US-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.COLD2)
    cold2 (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104SE9D-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.COLD2) {

        "temperature"  (Channel,
                    description:"Cooler temperature", units:"\u00b0C",
                           hwChan:0, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "setpoint"  (Channel,
                    description:"Cooler setpoint temperature", units:"\u00b0C",
                           hwChan:1, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "setPower"  (Channel,
                    description:"Cooler power setting", units:"Watt",
                           hwChan:2, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:60.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "power"  (Channel,
                    description:"Cooler power", units:"Watt",
                           hwChan:3, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:250.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOffEnabled"  (Channel,
                    description:"Cooler auto shutoff state (1 = auto off)", units:"unitless",
                           hwChan:4, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOffTemperature"  (Channel,
                    description:"Cooler auto shutoff temperature setting", units:"\u00b0C",
                           hwChan:5, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "autoOnTemperature"  (Channel,
                    description:"Cooler auto shutoff cancellation temperature setting", units:"\u00b0C",
                           hwChan:6, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        "rejectTemperature"  (Channel,
                    description:"Cooler reject temperature reading", units:"\u00b0C",
                           hwChan:7, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

    }

    
//    Turbo  (CryoTurboDevice, devcId:"/dev/ttyS3", lowSpeedMode:false, waterCooling:false,
    turbo  (CryoTurboDevice, devcId:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A107I7UQ-if00-port0", lowSpeedMode:false, waterCooling:false,
            ventValveByCmnd:true, interlockType:true, softStartMode:true,
            activeStopMode:true, model304:false) {

//        turboSpeed (Channel, description:"Turbo pump speed in RPM", units:"unitless", format:".0f",
//                    type:"Numeric", subtype:"DRIVEFREQ", scale:60, limitHi:100000)



    "current"      (Channel, description:"TurboPump current", units:"mA",
                       type:"Numeric", subtype:"CURRENT",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "voltage"      (Channel, description:"TurboPump voltage", units:"Volt",
                       type:"Numeric", subtype:"VOLTAGE",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "power"        (Channel, description:"TurboPump power", units:"Watt",
                       type:"Numeric", subtype:"POWER",
                       checkLo:"none", checkHi:"alarm", format:"%.0f",
                       limitHi:71.0, dbandHi:31.0, alarmHi:"AlarmGeneric")

    "driveFrequency"    (Channel, description:"TurboPump drive frequency", units:"Hz",
                       type:"Numeric", subtype:"DRIVEFREQ",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "pumpTemperature"     (Channel, description:"TurboPump pump temperature", 
                       units:"\u00b0C", 
                       type:"Numeric", subtype:"PUMP_TEMP", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboTempHighLimit")

    "cntrlrSinkTemperature" (Channel, description:"TurboPump controller sink temp.", 
                       units:"\u00b0C", 
                       type:"Numeric", subtype:"CONT_TEMP_SINK", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboTempHighLimit")

    "cntrlrAirTemperature"  (Channel, description:"TurboPump controller air temp.", 
                       units:"\u00b0C", 
                       type:"Numeric", subtype:"CONT_TEMP_AIR", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboTempHighLimit")

    "rpm"          (Channel, description:"TurboPump speed in RPM", units:"unitless",
                       type:"Numeric", subtype:"RPM",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "status"       (Channel, description:"TurboPump status: 5=normal, 6=fail", units:"unitless", 
                       type:"Numeric", subtype:"STATUS", 
                       format:"%.0f",
                       limitLo:-0.5, checkLo:"flag", dbandLo:5.0, limitHi:5.5,
                       checkHi:"alarm", alarmHi:"AlarmTurboStatusFail")




    }


    VQMonitor (GPVacMon835Device, serialdev:"/dev/serial/by-id/usb-Brooks_Automation_Inc._Granville-Phillips_VQM_835_835A0514-if00") {
        vqmpressure  (Channel, description:"Pressure Reading", units:"Torr", format:".3G",
                      hwChan:0,
                    limitLo:0.0, dbandLo:0.00000001, checkLo:"alarm", alarmLo:"AlarmPressureLowLimit",
                    checkHi:"alarm", limitHi:810.0, dbandHi:20.0, alarmHi:"AlarmPressureHighLimit")

    }




     /*
         Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volt".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
        The checking option: NONE, FLAG or ALARM
        The limit value.
        The alarm to be activated upon status transitions when ALARM is specified.
        The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status message to be broadcast, which can be used to update the trending database or to update any console displays.
*/







    VacPluto (VacPlutoDevice, node:"192.168.1.131",
              latchesUsed:[VacSysState.LATCH_CR_GATE_AO, VacSysState.LATCH_CR_GATE_NFC,
                           VacSysState.LATCH_CR_PUMP, VacSysState.LATCH_CR_VACUUM],
              condsUsed:[VacSysState.COND_CR_TRB_PRESS_10,
                         VacSysState.COND_CR_TRB_PUMP_OFF, VacSysState.COND_CR_VACUUM_001,
                         VacSysState.COND_CR_VACUUM_01])

//    VacPluto (VacPlutoDevice, node:"192.168.1.131",
//              condsUsed:[VacSysState.COND_CR_GATE_AO, VacSysState.COND_CR_GATE_NFC,
//                         VacSysState.COND_CR_PUMP])

    int cip1 = IonPumpDevice.CHAN_CIP1
    int hip1 = IonPumpDevice.CHAN_HIP1
    int hip2 = IonPumpDevice.CHAN_HIP2
    int oip  = IonPumpDevice.CHAN_OIP

    IonPumps (IonPumpDevice, ipAddr:"192.168.1.87") {

        CIP1C (IonPumpControl, hwChan:cip1, voltage:5000, current:0.002, power:9.9)

        "current" (Channel, description:"Cryo ion pump current", units:"mA",
                hwChan:cip1, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        "voltage" (Channel, description:"Cryo ion pump voltage", units:"Volt", format:".1f",
                hwChan:cip1, type:"VOLTAGE")

    }




}