import org.lsst.ccs.description.groovy.CCSBuilder;

import org.lsst.ccs.subsystem.common.devices.turbopump.*;
import org.lsst.ccs.subsystem.common.devices.refrigeration.*;
import org.lsst.ccs.subsystem.common.devices.refrigeration.data.RefrigerationConfig
import org.lsst.ccs.subsystem.common.devices.vacuum.*;
import org.lsst.ccs.subsystem.common.devices.power.distribution.*;

//import org.lsst.ccs.subsystem.comcamvacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.comcamvacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.comcamvacuum.IonPumpControl;
//import org.lsst.ccs.subsystem.comcamvacuum.CryoTurboDevice;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacSysState;


import org.lsst.ccs.subsystem.comcamvacuum.data.*;
import org.lsst.ccs.subsystem.comcamvacuum.*;
import org.lsst.ccs.subsystem.comcamvacuum.alerts.ComCamVacuumAlerts;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["comcam-vacuum"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

//Class pduClass = Class.forName("import org.lsst.ccs.common.devices.power.distribution.APC7900" + (runMode.equals("simulation") ? "Sim" : "") + "Device");
//Class turboClass = Class.forName("org.lsst.ccs.common.devices.turbopump.TwisTorr84" + "Device");

taskConfig = ["monitor-update/taskPeriodMillis":3000,"monitor-publish/taskPeriodMillis":3000]

builder.

    main (ComCamVacuumSubsystem, nodeTags:taskConfig, cryoPressChan:"vqmpressure", turboPressChan:"vqmpressure",
              turboSpeedChan:"TurboSpeed",
        switches:[VacSysState.SW_CRYO_TURBO, VacSysState.SW_CRYO_ION_PUMP1, VacSysState.SW_CRYO_VALVE,
                    VacSysState.SW_CRYOTEL_CRYO, VacSysState.SW_CRYOTEL_COLD1, VacSysState.SW_CRYOTEL_COLD2]) {
//                    VacSysState.SW_KOOLANCE, VacSysState.SW_KOOLCOLD, VacSysState.SW_CRYOTEL_CRYO, VacSysState.SW_CRYOTEL_COLD1, VacSysState.SW_CRYOTEL_COLD2,

    Turbo  (CryoTurboDevice, devcId:"/dev/ttyS0", lowSpeedMode:false, waterCooling:false,
            ventValveByCmnd:true, interlockType:true, softStartMode:true,
            activeStopMode:true, model304:false) {
        TurboSpeed (Channel, description:"Turbo pump speed", units:"rpm", format:".0f",
                    type:"Numeric", subtype:"DRIVEFREQ", scale:60, limitHi:100000)

    }


    VQMonitor (GPVacMon835Device, serialdev:"/dev/serial/by-id/usb-Brooks_Automation_Inc._Granville-Phillips_VQM_835_835A0514-if00") {
        vqmpressure  (Channel, description:"VQM Pressure Reading", units:"Torr", format:".3G",
                      hwChan:0,
                    limitLo:0.0, dbandLo:0.00000001, checkLo:"alarm", alarmLo:"AlarmPressureLowLimit",
                    checkHi:"alarm", limitHi:810.0, dbandHi:20.0, alarmHi:"AlarmPressureHighLimit")

    }

//    PDU20 (pduClass, node:"192.168.2.2")
//    PDU20 (APC7900Device, node:"192.168.2.2")

//    PDU15 (APC7900Device, node:"192.168.1.2")

    AlarmCryoHighTempLimit  (Alarm, description:"Cryo Plate high temperature alarm", eventParm:ComCamVacuumAlerts.CRYO_PLATE_TEMPERATURE_TOO_HIGH.ordinal())

    AlarmCryoLowTempLimit   (Alarm, description:"Cryo Plate low temperature alarm", eventParm:ComCamVacuumAlerts.CRYO_PLATE_TEMPERATURE_TOO_LOW.ordinal())
    
    AlarmColdHighTempLimit  (Alarm, description:"Cold Plate high temperature alarm", eventParm:ComCamVacuumAlerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.ordinal())

    AlarmColdLowTempLimit   (Alarm, description:"Cold Plate low temperature alarm", eventParm:ComCamVacuumAlerts.COLD_PLATE_TEMPERATURE_TOO_LOW.ordinal())

    AlarmPressureHighLimit  (Alarm, description:"Pressure too high alarm", eventParm:ComCamVacuumAlerts.PRESSURE_TOO_HIGH.ordinal())

    AlarmPressureLowLimit   (Alarm, description:"Pressure too low alarm", eventParm:ComCamVacuumAlerts.PRESSURE_TOO_LOW.ordinal())

    AlarmTurboStatusFail    (Alarm, description:"Turbo Pump Status = Fail", eventParm:ComCamVacuumAlerts.TURBO_PUMP_FAIL.ordinal())

    AlarmTurboTempHighLimit (Alarm, description:"Turbo Pump Temp too high", eventParm:ComCamVacuumAlerts.TURBO_PUMP_OVERTEMP.ordinal())

    AlarmGeneric  (Alarm, description:"Generic alarm", eventParm:ComCamVacuumAlerts.GENERIC.ordinal())


    CryoTelCryo  (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A107I7UW-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.CRYO)
    CryoTelCold1 (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A107I7UU-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.COLD1)
    CryoTelCold2 (AVCCryoDevice, serialdev:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A107I7US-if00-port0", baud:9600, devType:RefrigerationConfig.CryoTelType.COLD2)

    
//    AlarmHDWC  (Alarm, eventParm:ComCamVacuumConfig.EVENT_ID.CRYO.ordinal())
    AlarmHDWC  (Alarm, description:"Cold Plate high temperature alarm", eventParm:ComCamVacuumAlerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.ordinal())





     /*
         Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volts".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
        The checking option: NONE, FLAG or ALARM
        The limit value.
        The alarm to be activated upon status transitions when ALARM is specified.
        The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status message to be broadcast, which can be used to update the trending database or to update any console displays.
*/
/*
        PDU20Current  (Channel, description:"PDU20 current", units:"Amps",
                       devcName:"PDU20", hwChan:APC7900Device.CHAN_CURRENT, type:"POWER",
                       limitHi:12.0)

        PDU20Power    (Channel, description:"PDU20 power", units:"Watts",
                       devcName:"PDU20", hwChan:APC7900Device.CHAN_POWER, type:"POWER",
                       limitHi:1320.0)

        PDU15Current  (Channel, description:"PDU15 current", units:"Amps",
                       devcName:"PDU15", hwChan:APC7900Device.CHAN_CURRENT, type:"POWER",
                       limitHi:12.0)

        PDU15Power    (Channel, description:"PDU15 power", units:"Watts",
                       devcName:"PDU15", hwChan:APC7900Device.CHAN_POWER, type:"POWER",
                       limitHi:1320.0)
*/
        VQMState      (Channel, description:"VQM controller state", format:".0f",
                       devcName:"PDU20", hwChan:0, type:"POWER", subtype:ComCamVacuumOutlets.VQMCONTROLLER.getOutletName(),
                       limitLo:0.9, limitHi:1.1)


        CryoTemp  (Channel,
                    description:"Cooler temperature", units:"C",
                           devcName:"CryoTelCryo", hwChan:0, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        CryoSetPt  (Channel,
                    description:"Cooler setpoint temperature", units:"C",
                           devcName:"CryoTelCryo", hwChan:1, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        CryoSetPwr  (Channel,
                    description:"Cooler power", units:"W",
                           devcName:"CryoTelCryo", hwChan:2, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:60.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        CryoPwr  (Channel,
                    description:"Cooler power", units:"W",
                           devcName:"CryoTelCryo", hwChan:3, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:250.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        CryoAutoOff  (Channel,
                    description:"Cooler auto shutoff state", units:"1",
                           devcName:"CryoTelCryo", hwChan:4, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        CryoAutoOffTemp  (Channel,
                    description:"Cooler auto shutoff temperature setting", units:"1",
                           devcName:"CryoTelCryo", hwChan:5, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        CryoAutoOnTemp  (Channel,
                    description:"Cooler auto shutoff turn back on temperature setting", units:"1",
                           devcName:"CryoTelCryo", hwChan:6, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        CryoRejectTemp  (Channel,
                    description:"Cooler reject temperature reading", units:"1",
                           devcName:"CryoTelCryo", hwChan:7, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")


        Cold1Temp  (Channel,
                    description:"Cooler temperature", units:"C",
                           devcName:"CryoTelCold1", hwChan:0, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold1SetPt  (Channel,
                    description:"Cooler setpoint temperature", units:"C",
                           devcName:"CryoTelCold1", hwChan:1, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        Cold1SetPwr  (Channel,
                    description:"Cooler power", units:"W",
                           devcName:"CryoTelCold1", hwChan:2, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:250.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold1Pwr  (Channel,
                    description:"Cooler power", units:"W",
                           devcName:"CryoTelCold1", hwChan:3, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:60.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold1AutoOff  (Channel,
                    description:"Cooler auto shutoff state", units:"1",
                           devcName:"CryoTelCold1", hwChan:4, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold1AutoOffTemp  (Channel,
                    description:"Cooler auto shutoff temperature setting", units:"1",
                           devcName:"CryoTelCold1", hwChan:5, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold1AutoOnTemp  (Channel,
                    description:"Cooler auto shutoff turn back on temperature setting", units:"1",
                           devcName:"CryoTelCold1", hwChan:6, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold1RejectTemp  (Channel,
                    description:"Cooler reject temperature reading", units:"1",
                           devcName:"CryoTelCold1", hwChan:7, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        Cold2Temp  (Channel,
                    description:"Cooler temperature", units:"C",
                           devcName:"CryoTelCold2", hwChan:0, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold2SetPt  (Channel,
                    description:"Cooler setpoint temperature", units:"C",
                           devcName:"CryoTelCold2", hwChan:1, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-130.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold2SetPwr  (Channel,
                    description:"Cooler power", units:"W",
                           devcName:"CryoTelCold2", hwChan:2, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:60.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold2Pwr  (Channel,
                    description:"Cooler power", units:"W",
                           devcName:"CryoTelCold2", hwChan:3, type:"WATTS", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:250.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold2AutoOff  (Channel,
                    description:"Cooler auto shutoff state", units:"1",
                           devcName:"CryoTelCold2", hwChan:4, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold2AutoOffTemp  (Channel,
                    description:"Cooler auto shutoff temperature setting", units:"1",
                           devcName:"CryoTelCold2", hwChan:5, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold2AutoOnTemp  (Channel,
                    description:"Cooler auto shutoff turn back on temperature setting", units:"1",
                           devcName:"CryoTelCold2", hwChan:6, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")
        Cold2RejectTemp  (Channel,
                    description:"Cooler reject temperature reading", units:"1",
                           devcName:"CryoTelCold2", hwChan:7, type:"TEMP", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-150.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

/*                       
        RoughPumpState (Channel, description:"ROUGH-PUMP state", format:".0f",
                       devcName:"PDU20", hwChan:0, type:"POWER", subtype:ComCamVacuumOutlets.ROUGHINGPUMP.getOutletName(),
                       limitLo:0.9, limitHi:1.1)

        TurboPumpState (Channel, description:"TURBO-PUMP state", format:".0f",
                   devcName:"PDU20", hwChan:0, type:"POWER", subtype:ComCamVacuumOutlets.TURBOPUMP.getOutletName(),
                   limitLo:0.9, limitHi:1.1)

    VATValveState (Channel, description:"VATValve state", format:".0f",
                   devcName:"PDU20", hwChan:0, type:"POWER", subtype:ComCamVacuumOutlets.VACUUMVALVE.getOutletName(),
                   limitLo:0.9, limitHi:1.1)
*/

    TurboCurrent      (Channel, description:"TurboPump current", units:"mA dc",
                       devcName:"Turbo", type:"Numeric", subtype:"CURRENT",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboVoltage      (Channel, description:"TurboPump voltage", units:"V dc",
                       devcName:"Turbo", type:"Numeric", subtype:"VOLTAGE",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboPower        (Channel, description:"TurboPump power", units:"W",
                       devcName:"Turbo", type:"Numeric", subtype:"POWER",
                       checkLo:"none", checkHi:"alarm", format:"%.0f",
                       limitHi:71.0, dbandHi:31.0, alarmHi:"AlarmGeneric")

    TurboDriveFreq    (Channel, description:"TurboPump drive freq.", units:"Hz",
                       devcName:"Turbo", type:"Numeric", subtype:"DRIVEFREQ",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboPumpTemp     (Channel, description:"TurboPump pump temperature", 
                       units:"deg C", devcName:"Turbo", 
                       type:"Numeric", subtype:"PUMP_TEMP", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboTempHighLimit")

    TurboContTempSink (Channel, description:"TurboPump controller sink temp.", 
                       units:"deg C", devcName:"Turbo", 
                       type:"Numeric", subtype:"CONT_TEMP_SINK", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboTempHighLimit")

    TurboContTempAir  (Channel, description:"TurboPump controller air temp.", 
                       units:"deg C", devcName:"Turbo", 
                       type:"Numeric", subtype:"CONT_TEMP_AIR", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboTempHighLimit")

    TurboRPM          (Channel, description:"TurboPump speed", units:"RPM",
                       devcName:"Turbo", type:"Numeric", subtype:"RPM",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboStatus       (Channel, description:"TurboPump status: 5=normal, 6=fail", 
                       devcName:"Turbo", type:"Numeric", subtype:"STATUS", 
                       format:"%.0f",
                       limitLo:-0.5, checkLo:"flag", dbandLo:5.0, limitHi:5.5,
                       checkHi:"alarm", alarmHi:"AlarmTurboStatusFail")


//    VacPluto (VacPlutoDevice, node:"192.168.1.131",
//              condsUsed:[VacSysState.COND_CR_GATE_AO, VacSysState.COND_CR_GATE_NFC,
//                         VacSysState.COND_CR_PUMP])

    int cip1 = IonPumpDevice.CHAN_CIP1
    int hip1 = IonPumpDevice.CHAN_HIP1
    int hip2 = IonPumpDevice.CHAN_HIP2
    int oip  = IonPumpDevice.CHAN_OIP

    IonPumps (IonPumpDevice, ipAddr:"192.168.1.87") {

        CIP1C (IonPumpControl, hwChan:cip1, voltage:5000, current:0.002, power:9.9)

        CIP1_I (Channel, description:"Cryo ion pump 1 current", units:"mA",
                hwChan:cip1, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP1_V (Channel, description:"Cryo ion pump 1 voltage", units:"Volts", format:".1f",
                hwChan:cip1, type:"VOLTAGE")

    }




}