/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.common.devices.PlutoDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class PlutoControl
implements HasLifecycle {
    private static final int TYPE_BIT = 0;
    private static final int TYPE_REG = 1;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private String type;
    private double offset = 0.0;
    private double scale = 1.0;
    protected int hwChan = 0;
    private static final Logger LOG;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private PlutoDevice pDevc;
    private int iType;
    private int area;
    @LookupName
    private String name;

    public void init() {
        int maxChan;
        if (this.type == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"type", (String)"not specified");
        }
        Integer iTyp = null;
        String[] typeFields = this.type.split(":", -1);
        if (typeFields.length == 2) {
            iTyp = typeMap.get(typeFields[0].toUpperCase());
        }
        try {
            this.area = Integer.decode(typeFields[1]);
        }
        catch (NumberFormatException e) {
            this.area = -1;
        }
        if (iTyp == null || this.area < 0 || this.area >= 4) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"type", (String)"has invalid value");
        }
        this.iType = iTyp;
        int n = maxChan = this.iType == 0 ? 16 : 2;
        if (this.hwChan >= maxChan) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"hwchan", (String)"has invalid value");
        }
    }

    public void writeValue(double value) {
        int ival = (int)((value - this.offset) / this.scale);
        if (this.iType == 0) {
            this.pDevc.writeBit(this.area, this.hwChan, ival);
        } else {
            this.pDevc.writeRegister(this.area, this.hwChan, ival);
        }
    }

    static {
        typeMap.put("BIT", 0);
        typeMap.put("REG", 1);
        LOG = Logger.getLogger((String)PlutoControl.class.getName());
    }
}

