/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.comcamvacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.VacuumState;

public class VacSysState
implements Serializable {
    public static final String KEY = "ComCamVacuumState";
    public static final int SW_CRYO_TURBO = 0;
    public static final int SW_CRYO_ION_PUMP1 = 1;
    public static final int SW_CRYO_VALVE = 2;
    public static final int SW_HX_TURBO = 3;
    public static final int SW_HX_ION_PUMP1 = 4;
    public static final int SW_OR_ION_PUMP = 5;
    public static final int SW_CRYOTEL_CRYO = 6;
    public static final int SW_CRYOTEL_COLD1 = 7;
    public static final int SW_CRYOTEL_COLD2 = 8;
    public static final int NUM_SWITCHES = 9;
    public static final int COND_CR_VACUUM = 0;
    public static final int COND_CR_GATE_NFC = 1;
    public static final int COND_CR_GATE_AO = 2;
    public static final int COND_CR_PUMP = 3;
    public static final int COND_HX_VACUUM = 4;
    public static final int COND_HX_GATE_NFC = 5;
    public static final int COND_HX_GATE_AO = 6;
    public static final int COND_HX_PUMP = 7;
    public static final int NUM_CONDITIONS = 8;
    private int tickMillis;
    private VacuumState vacuumState = VacuumState.UNKNOWN;
    private int switchMask;
    private int conditionMask;
    private final SwitchState[] switchState = new SwitchState[9];
    private final SwitchEnable[] switchEnable = new SwitchEnable[9];
    private final DeviceState[] deviceState = new DeviceState[9];
    private final ConditionState[] conditionState = new ConditionState[8];
    private static final long serialVersionUID = 2081368367194546251L;

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setVacuumState(VacuumState value) {
        this.vacuumState = value;
    }

    public VacuumState getVacuumState() {
        return this.vacuumState;
    }

    public void addSwitch(int sw) {
        this.switchMask |= 1 << sw;
    }

    public boolean hasSwitch(int sw) {
        return (this.switchMask & 1 << sw) != 0;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setSwitchEnable(int sw, SwitchEnable enable) {
        this.switchEnable[sw] = enable;
    }

    public SwitchEnable getSwitchEnable(int sw) {
        return this.switchEnable[sw];
    }

    public void setDeviceState(int sw, DeviceState state) {
        this.deviceState[sw] = state;
    }

    public DeviceState getDeviceState(int sw) {
        return this.deviceState[sw];
    }

    public void addCondition(int cond) {
        this.conditionMask |= 1 << cond;
    }

    public boolean hasCondition(int cond) {
        return (this.conditionMask & 1 << cond) != 0;
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }
}

