/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mks;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Multidrop;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.Model9XX;

public class Test9XX {
    private final Model9XX[] devs = new Model9XX[]{new Model9XX(), new Model9XX(), new Model9XX(), new Model9XX(), new Model9XX()};
    private Model9XX dev = this.devs[0];
    private int devNumber = 0;

    @Command(name="setdevnum", description="Set the current device number")
    public void setDeviceNum(@Argument(description="The device number") int number) throws DriverException {
        if (number < 0 || number >= this.devs.length) {
            throw new DriverException("Invalid device number");
        }
        this.devNumber = number;
        this.dev = this.devs[this.devNumber];
    }

    @Command(name="showdevnum", description="Show the current device number")
    public int showDeviceNum() {
        return this.devNumber;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") Multidrop.ConnType connType, @Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.dev.open(connType, ident, -1);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") Multidrop.ConnType connType, @Argument(name="ident", description="Identification") String ident, @Argument(name="addr", description="Device address") int addr) throws DriverException {
        this.dev.open(connType, ident, addr);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") Multidrop.ConnType connType, @Argument(name="ident", description="Identification") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="addr", description="Device address") int address) throws DriverException {
        this.dev.open(connType, ident, baud, address);
    }

    @Command(name="close", description="Close the connection")
    public void close() throws DriverException {
        this.dev.close();
    }

    @Command(name="write", description="Write a command")
    public void write(@Argument(description="Command") String cmnd) throws DriverException {
        this.dev.writeCmnd(cmnd);
    }

    @Command(name="read", description="Read response from a command")
    public String read(@Argument(description="Command") String cmnd) throws DriverException {
        return this.dev.readString(cmnd);
    }

    @Command(name="lock", description="Set protected settings lock")
    public void setLock(@Argument(description="ON or OFF") OnOff onoff) throws DriverException {
        this.dev.setLock(onoff == OnOff.ON);
    }

    @Command(name="setdefaults", description="Set factory defaults")
    public void setDefaults() throws DriverException {
        this.dev.setDefaults();
    }

    @Command(name="setdefaults", description="Set factory defaults")
    public void setDefaults(@Argument(description="Default item to set") Model9XX.Default item) throws DriverException {
        this.dev.setDefaults(item);
    }

    @Command(name="showdevice", description="Show device type")
    public String showDevice() throws DriverException {
        return this.dev.getDeviceType();
    }

    @Command(name="showfwversion", description="Show firmware version")
    public String showFwVersion() throws DriverException {
        return this.dev.getFirmwareVersion();
    }

    @Command(name="showhwversion", description="Show hardware version")
    public String showHwVersion() throws DriverException {
        return this.dev.getHardwareVersion();
    }

    @Command(name="showmanufacturer", description="Show manufacturer")
    public String showManufacturer() throws DriverException {
        return this.dev.getManufacturer();
    }

    @Command(name="showmodel", description="Show model")
    public String showModel() throws DriverException {
        return this.dev.getModel();
    }

    @Command(name="showpart", description="Show part number")
    public String showPart() throws DriverException {
        return this.dev.getPartNumber();
    }

    @Command(name="showserial", description="Show serial number")
    public String showSerial() throws DriverException {
        return this.dev.getSerialNumber();
    }

    @Command(name="setusertag", description="Set user tag")
    public void setUserTag(@Argument(description="The tag string") String tag) throws DriverException {
        this.dev.setUserTag(tag);
    }

    @Command(name="showusertag", description="Show user tag")
    public String showUserTag() throws DriverException {
        return this.dev.getUserTag();
    }

    @Command(name="showstatus", description="Show status word")
    public char showStatus() throws DriverException {
        return this.dev.getStatus();
    }

    @Command(name="showontime", description="Show unit on time")
    public String showOnTime() throws DriverException {
        return this.dev.getTimeOn() + " hours";
    }

    @Command(name="showsensortime", description="Show cold cathode on time")
    public String showSensorTime() throws DriverException {
        return this.dev.getSensorTimeOn() + " hours";
    }

    @Command(name="showsensordose", description="Show cold cathose pressure dose")
    public String showSensorDose() throws DriverException {
        return this.dev.getSensorDose() + " " + this.getUnitsString() + " hours";
    }

    @Command(name="setunits", description="Set pressure units")
    public void setUnits(@Argument(description="Pressure units") Model9XX.Unit units) throws DriverException {
        this.dev.setPressureUnit(units);
    }

    @Command(name="showunits", description="Show pressure units")
    public Model9XX.Unit showUnits() throws DriverException {
        return this.dev.getPressureUnit();
    }

    @Command(name="setgastype", description="Set calibration gas type")
    public void setGasType(@Argument(description="Gas type") Model9XX.Gas gas) throws DriverException {
        this.dev.setCalibrationGas(gas);
    }

    @Command(name="showgastype", description="Show calibration gas type")
    public Model9XX.Gas showGasType() throws DriverException {
        return this.dev.getCalibrationGas();
    }

    @Command(name="readpressure", description="Read vacuum pressure")
    public String readPressure() throws DriverException {
        return this.dev.readPressure() + " " + this.getUnitsString();
    }

    @Command(name="readpressure", description="Read vacuum pressure")
    public String readPressure(@Argument(description="Sensor to use") Model9XX.Sensor sensor) throws DriverException {
        return this.dev.readPressure(sensor) + " " + this.getUnitsString();
    }

    @Command(name="setatmospheric", description="Set atmospheric pressure")
    public void setAtmospheric(@Argument(description="Atmospheric pressure") double press) throws DriverException {
        this.dev.calibrateAtmospheric(press);
    }

    @Command(name="showatmospheric", description="Show atmospheric pressure difference")
    public String showAtmospheric() throws DriverException {
        return String.valueOf(this.dev.getAtmospheric());
    }

    @Command(name="readtemperature", description="Read MicroPirani temperature")
    public String readTemperature() throws DriverException {
        return String.valueOf(this.dev.readTemperature());
    }

    @Command(name="setrelaytrip", description="Set relay trip point")
    public void setRelayTrip(@Argument(description="Relay number") int relay, @Argument(description="Trip point value") double value) throws DriverException {
        this.dev.setRelayTrip(relay, value);
    }

    @Command(name="showrelaytrip", description="Show relay trip point")
    public String showRelayTrip(@Argument(description="Relay number") int relay) throws DriverException {
        return String.valueOf(this.dev.getRelayTrip(relay));
    }

    @Command(name="setrelayhyst", description="Set relay hysteresis")
    public void setRelayHyst(@Argument(description="Relay number") int relay, @Argument(description="Hysteresis value") double value) throws DriverException {
        this.dev.setRelayHyst(relay, value);
    }

    @Command(name="showrelayhyst", description="Show relay hysteresis")
    public String showRelayHyst(@Argument(description="Relay number") int relay) throws DriverException {
        return String.valueOf(this.dev.getRelayHyst(relay));
    }

    @Command(name="setrelaydirn", description="Set relay trip direction")
    public void setRelayDirn(@Argument(description="Relay number") int relay, @Argument(description="Trip direction") Model9XX.Direction dirn) throws DriverException {
        this.dev.setRelayDirection(relay, dirn);
    }

    @Command(name="showrelaydirn", description="Show relay trip direction")
    public Model9XX.Direction showRelayDirn(@Argument(description="Relay number") int relay) throws DriverException {
        return this.dev.getRelayDirection(relay);
    }

    @Command(name="setrelayenable", description="Enable a relay")
    public void setRelayEnable(@Argument(description="Relay number") int relay, @Argument(description="Enable type") Model9XX.Enable enable) throws DriverException {
        this.dev.setRelayEnable(relay, enable);
    }

    @Command(name="showrelayenable", description="Show whether relay enabled")
    public Model9XX.Enable showRelayEnable(@Argument(description="Relay number") int relay) throws DriverException {
        return this.dev.getRelayEnable(relay);
    }

    @Command(name="isrelayactive", description="Show whether relay is active")
    public String isRelayActive(@Argument(description="Relay number") int relay) throws DriverException {
        return String.valueOf(this.dev.isRelayActive(relay));
    }

    @Command(name="setanalogout", description="Set analog output parameters")
    public void setAnalogOut(@Argument(description="Analog channel number (1 - 2)") int chan, @Argument(description="Sensor to use") Model9XX.Sensor sensor, @Argument(description="Analog out curve number") int curve) throws DriverException {
        this.dev.setAnalogOut(chan, sensor, curve);
    }

    @Command(name="showanalogout", description="Show analog output setting")
    public String showAnalogOut(@Argument(description="Analog channel number (1 - 2)") int chan) throws DriverException {
        return this.dev.getAnalogOut(chan);
    }

    @Command(name="setbaud", description="Set baud rate")
    public void setBaud(@Argument(description="Baud rate") int baud) throws DriverException {
        this.dev.setBaudRate(baud);
    }

    @Command(name="showbaud", description="Show baud rate")
    public int showBaud() throws DriverException {
        return this.dev.getBaudRate();
    }

    @Command(name="setaddress", description="Set (change) device address")
    public void setAddress(@Argument(description="Address (1 - 253)") int address) throws DriverException {
        this.dev.changeAddress(address);
    }

    @Command(name="settimeout", description="Set response timeout")
    public void setTimeout(@Argument(description="Timeout (secs)") double timeout) throws DriverException {
        this.dev.setTimeout(timeout);
    }

    private String getUnitsString() throws DriverException {
        return this.dev.getPressureUnit().name().toLowerCase();
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

