/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.comcamvacuum.CryoTurboDevice;
import org.lsst.ccs.subsystem.comcamvacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.comcamvacuum.SwitchNames;
import org.lsst.ccs.subsystem.comcamvacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.comcamvacuum.alerts.ComCamVacuumAlerts;
import org.lsst.ccs.subsystem.comcamvacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.VacuumState;
import org.lsst.ccs.subsystem.comcamvacuum.data.ComCamVacuumAgentProperties;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacSysState;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacuumException;
import org.lsst.ccs.subsystem.common.devices.power.distribution.APC7900Device;
import org.lsst.ccs.subsystem.common.devices.refrigeration.AVCCryoDevice;
import org.lsst.ccs.subsystem.common.devices.refrigeration.data.RefrigerationConfig;
import org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorr84Device;
import org.lsst.ccs.subsystem.common.devices.vacuum.GPVacMon835Device;
import org.lsst.ccs.utilities.logging.Logger;

public class ComCamVacuumSubsystem
implements HasLifecycle,
Monitor.AlarmHandler {
    private static final double PRESS_ATMOS = 759.0;
    private static final double PRESS_TURBO_LOW = 5.0;
    private static final double PRESS_FORELINE_LOW = 5.0;
    private static final double PRESS_DIFF_LOW = 0.09;
    private static final double PRESS_DIFF_HIGH = 20.0;
    private static final double PRESS_ION_OFF = 1.0E-5;
    private static final double PRESS_ION_ENABLE = 1.0E-6;
    private static final double PRESS_VACUUM = 1.0E-7;
    private static final double TURBO_MAX = 60000.0;
    private static final double TURBO_LOW = 6000.0;
    private static final double TURBO_HIGH = 30000.0;
    private static final int[] switchChannels = new int[16];
    private static final Map<TwisTorr84.PumpStatus, DeviceState> turboStateMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Monitor.AlarmHandler alarmHandler;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService as;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService ass;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private VacPlutoDevice plutoDevc = null;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private CryoTurboDevice cryoTurboDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private IonPumpDevice ionPumpDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    Map<String, AVCCryoDevice> avcMap = new HashMap<String, AVCCryoDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Channel> channelMap = new LinkedHashMap<String, Channel>();
    private String cryoPressChan;
    private String turboPressChan;
    private String turboSpeedChan;
    private String forelinePressChan;
    private String CryoTempChan;
    private String Cold1TempChan;
    private String Cold2TempChan;
    private String IonPumpVoltageChan;
    private List<Integer> switches;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*20.*")
    private APC7900Device pdu20Devc;
    private final VacSysState vacState = new VacSysState();
    private Set<Integer> switchSet;
    private final Device[] switchDevices = new Device[16];
    private Channel cryoPressure;
    private Channel turboPressure;
    private Channel turboSpeed;
    private Channel forelinePressure;
    private Channel CryoTemp;
    private Channel Cold1Temp;
    private Channel Cold2Temp;
    private boolean running = true;
    private final Map<String, Integer> switchNameMap = new LinkedHashMap<String, Integer>();
    private boolean plcActive = true;
    private final Logger sLog;
    private String last_alertStr;
    private boolean useInfoAlerts = System.getProperty("org.lsst.ccs.subsystem.comcamvacuumPowerInfoAlerts", "false").contains("true");
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStatusAggregatorService aggregatorService;

    public ComCamVacuumSubsystem() {
        this.sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.comcamvacuum");
    }

    public void postInit() {
        this.subsys.setAgentProperty(ComCamVacuumAgentProperties.COMCAMVACUUM_TYPE_AGENT_PROPERTY, ComCamVacuumSubsystem.class.getCanonicalName());
        if (this.switches != null) {
            this.switchSet = new HashSet<Integer>(this.switches);
        } else {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"Switch list", (String)"not specified");
        }
        if (this.cryoTurboDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"Cryo turbo pump device", (String)"not specified");
        }
        if (this.ionPumpDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"Ion pump device", (String)"not specified");
        }
        if (this.forelinePressChan != null) {
            this.forelinePressure = this.channelMap.get(this.forelinePressChan);
        }
        if (this.cryoPressChan != null) {
            this.cryoPressure = this.channelMap.get(this.cryoPressChan);
        }
        if (this.cryoPressure == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"Cryo pressure channel", (String)"not specified or not defined");
        }
        if (this.turboPressChan != null) {
            this.turboPressure = this.channelMap.get(this.turboPressChan);
        }
        if (this.turboPressure == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"Turbo pump pressure channel", (String)"not specified or not defined");
        }
        if (this.turboSpeedChan != null) {
            this.turboSpeed = this.channelMap.get(this.turboSpeedChan);
        }
        if (this.turboSpeed == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"Turbo pump speed channel", (String)"not specified or not defined");
        }
        List<Integer> ipChannels = this.ionPumpDevc.getChannelNumbers();
        Iterator<Integer> swIter = this.switchSet.iterator();
        while (swIter.hasNext()) {
            int sw = swIter.next();
            switch (sw) {
                case 0: {
                    this.switchDevices[sw] = this.cryoTurboDevc;
                    break;
                }
                case 2: {
                    this.switchDevices[sw] = this.pdu20Devc;
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.switchDevices[sw] = this.plutoDevc;
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    this.switchDevices[sw] = this.ionPumpDevc;
                    if (ipChannels.contains(switchChannels[sw])) break;
                    swIter.remove();
                    break;
                }
                case 11: {
                    this.switchDevices[sw] = this.pdu20Devc;
                    break;
                }
                case 15: {
                    this.switchDevices[sw] = this.pdu20Devc;
                    break;
                }
                case 12: {
                    this.sLog.info((Object)"attempting to setup switch for CryoTelCryo");
                    this.switchDevices[sw] = (Device)this.avcMap.get("CryoTelCryo");
                    break;
                }
                case 13: {
                    this.switchDevices[sw] = (Device)this.avcMap.get("CryoTelCold1");
                    break;
                }
                case 14: {
                    this.switchDevices[sw] = (Device)this.avcMap.get("CryoTelCold2");
                }
            }
        }
        Iterator<Object> sw = this.switchSet.iterator();
        while (sw.hasNext()) {
            int sw2 = sw.next();
            this.vacState.addSwitch(sw2);
            this.vacState.setSwitchState(sw2, SwitchState.OFFLINE);
            this.vacState.setSwitchEnable(sw2, SwitchEnable.OFF);
        }
        for (String swName : SwitchNames.NAME_MAP.keySet()) {
            int sw3 = SwitchNames.NAME_MAP.get(swName);
            if (!this.switchSet.contains(sw3)) continue;
            this.switchNameMap.put(swName, sw3);
        }
        GPVacMon835Device vqm = new GPVacMon835Device();
        this.sLog.info((Object)("Configured the status aggregator to listen to subsystems: " + System.getProperty("org.lsst.ccs.subsystem.teststand", "ts") + " " + System.getProperty("org.lsst.ccs.subsystem.rebps", "ccs-rebps") + " " + System.getProperty("org.lsst.ccs.subsystem.comcamvacuum", "comcamvacuum")));
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.apts.scheduleAgentPeriodicTask(pt);
        this.ass.registerState(VacuumState.class, "ComCam Vacuum state", (Object)this);
        this.ass.updateAgentState(new Enum[]{VacuumState.UNKNOWN});
    }

    public void postStart() {
        this.sLog.info((Object)"ComCamVacuum subsystem started");
    }

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        if (this.alarmHandler != null) {
            return this.alarmHandler.processAlarm(event, parm, cause, alarmName);
        }
        return false;
    }

    public void Sleep(double secs) {
        if (secs <= 0.0) {
            return;
        }
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            this.sLog.error((Object)("Rude awakening!" + ex));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state")
    public VacSysState getVacuumState() {
        this.vacState.setTickMillis(this.getTickPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws VacuumException {
        return new ArrayList<String>(this.switchNameMap.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        try {
            if (!this.switchSet.contains(sw)) {
                throw new VacuumException("Invalid switch number: " + sw);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        Integer sw = this.switchNameMap.get(name);
        try {
            if (sw == null) {
                throw new VacuumException("Invalid switch name: " + name);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        this.sLog.info((Object)("setSwitch called for sw = " + sw));
        if (state == SwitchState.OFFLINE) {
            this.sLog.info((Object)("Switch sw = " + sw + " is offline"));
            return;
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON && enable != SwitchEnable.WAS_ON) {
            this.sLog.info((Object)("enable = " + enable + " SwitchEnable.ON = " + SwitchEnable.ON + " SwitchEnable.WAS_ON = " + SwitchEnable.WAS_ON));
            return;
        }
        this.sLog.info((Object)("proceeding with setting switch sw = " + sw));
        Device swDevice = this.switchDevices[sw];
        try {
            if (swDevice instanceof TwisTorr84Device) {
                if (on) {
                    ((TwisTorr84Device)swDevice).startTurboPump();
                } else {
                    ((TwisTorr84Device)swDevice).stopTurboPump();
                }
            } else if (swDevice == this.plutoDevc) {
                this.plutoDevc.setSwitchOn(switchChannels[sw], on);
            } else if (swDevice == this.ionPumpDevc) {
                this.ionPumpDevc.setChannelOn(switchChannels[sw], on);
            } else if (swDevice == this.pdu20Devc && sw == 11) {
                for (String oname : this.pdu20Devc.getOutletNames()) {
                    if (!oname.toUpperCase().contains("KOOLANCE")) continue;
                    this.sLog.info((Object)("Setting KOOLANCE outlet state on PDU with name - " + this.pdu20Devc.getName()));
                    if (on) {
                        this.pdu20Devc.forceOutletOn(oname);
                        continue;
                    }
                    this.pdu20Devc.forceOutletOff(oname);
                }
            } else if (swDevice == this.pdu20Devc && sw == 15) {
                for (String oname : this.pdu20Devc.getOutletNames()) {
                    if (!oname.toUpperCase().contains("CRYOTEL")) continue;
                    this.sLog.info((Object)("Setting CRYOTEL outlet state on PDU with name - " + this.pdu20Devc.getName()));
                    if (on) {
                        this.pdu20Devc.forceOutletOn(oname);
                        continue;
                    }
                    this.pdu20Devc.forceOutletOff(oname);
                }
            } else if (swDevice == this.pdu20Devc && sw == 2) {
                for (String oname : this.pdu20Devc.getOutletNames()) {
                    if (!oname.toUpperCase().contains("VATVALVE")) continue;
                    this.sLog.info((Object)("Setting VAT valve outlet state on PDU with name - " + this.pdu20Devc.getName()));
                    if (on) {
                        this.pdu20Devc.forceOutletOn(oname);
                        continue;
                    }
                    this.pdu20Devc.forceOutletOff(oname);
                }
            } else if (sw == 12 || sw == 13 || sw == 14) {
                this.sLog.info((Object)("setting CryoTel (sw = " + sw + " ) to state " + (on ? "ON" : "OFF")));
                ((AVCCryoDevice)swDevice).setMode(on ? "ON" : "OFF");
            } else {
                this.sLog.info((Object)("swDevice not identified for sw=" + sw));
            }
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    private Boolean isSwitchOn(int sw) {
        Boolean value = false;
        Device swDevice = this.switchDevices[sw];
        if (swDevice instanceof TwisTorr84Device) {
            try {
                DeviceState st = turboStateMap.get(((TwisTorr84Device)swDevice).readTurboStatus());
                value = st != DeviceState.STOPPED && st != DeviceState.BRAKING;
            }
            catch (DriverException e) {
                value = null;
            }
        } else if (swDevice == this.plutoDevc) {
            if (this.plutoDevc != null) {
                value = this.plutoDevc.isSwitchOn(switchChannels[sw]);
            }
        } else if (swDevice == this.ionPumpDevc) {
            value = this.ionPumpDevc.isChannelOn(switchChannels[sw]);
        } else if (swDevice == this.pdu20Devc && sw == 11) {
            try {
                value = this.pdu20Devc.isOutletOn("KOOLANCE");
            }
            catch (DriverException ex) {
                this.sLog.error((Object)ex);
            }
        } else if (swDevice == this.pdu20Devc && sw == 2) {
            try {
                value = this.pdu20Devc.isOutletOn("VATvalve");
            }
            catch (DriverException ex) {
                this.sLog.error((Object)ex);
            }
        } else if (swDevice == this.pdu20Devc && sw == 15) {
            try {
                value = this.pdu20Devc.isOutletOn("CRYOTEL");
            }
            catch (DriverException ex) {
                this.sLog.error((Object)ex);
            }
        } else if (sw == 12 || sw == 13 || sw == 14) {
            try {
                value = ((AVCCryoDevice)swDevice).getMode().contains("ON");
            }
            catch (DriverException ex) {
                this.sLog.error((Object)ex);
            }
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearCondition(@Argument(description="The condition number") int cond) throws VacuumException {
        try {
            this.plutoDevc.clearCondition(cond);
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.vacState.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    private void updateVacuumState() {
        if (!this.running) {
            return;
        }
        if (this.plutoDevc != null) {
            boolean isplcactive_response = false;
            try {
                isplcactive_response = this.plutoDevc.isPLCActive();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isplcactive_response) {
                if (!this.plcActive) {
                    this.as.raiseAlert(ComCamVacuumAlerts.VACUUM_PLC_NOT_ALIVE.getAlert(), AlertState.NOMINAL, "Vacuum PLC is alive");
                    this.plcActive = true;
                }
            } else if (this.plcActive) {
                this.as.raiseAlert(ComCamVacuumAlerts.VACUUM_PLC_NOT_ALIVE.getAlert(), AlertState.ALARM, "Vacuum PLC has died");
                this.plcActive = false;
            }
        }
        double forelinePr = 0.0;
        if (this.forelinePressChan != null) {
            this.forelinePressure.readValue();
        }
        double cryoPr = this.cryoPressure.readValue();
        double turboPr = this.turboPressure.readValue();
        this.sLog.fine((Object)("current turboPr = " + turboPr));
        double turboSp = this.turboSpeed.readValue();
        boolean changed = false;
        for (int sw = 0; sw < 16; ++sw) {
            SwitchEnable enabled;
            Boolean isOn;
            if (!this.vacState.hasSwitch(sw)) continue;
            Boolean enable = false;
            boolean turnOff = false;
            DeviceState devState = null;
            switch (sw) {
                case 2: {
                    if (!(Double.isNaN(cryoPr) || Double.isNaN(turboPr) || Double.isNaN(turboSp))) {
                        double prDiff = Math.abs(turboPr - cryoPr);
                        enable = prDiff <= 20.0 && turboSp < 6000.0 || prDiff <= 0.09 && turboSp > 30000.0;
                    }
                    boolean enable2 = !Double.isNaN(forelinePr) && !Double.isNaN(turboSp) && (forelinePr < 5.0 || turboSp < 6000.0);
                    enable = enable & enable2;
                    if (Double.isNaN(turboPr)) break;
                    turnOff = !enable2;
                    break;
                }
                case 0: {
                    this.sLog.fine((Object)("turboPr = " + turboPr + " forelinePr = " + forelinePr + " turboSp = " + turboSp));
                    if (!(Double.isNaN(turboPr) || Double.isNaN(forelinePr) || Double.isNaN(turboSp))) {
                        enable = turboPr < 5.0 && (forelinePr < 5.0 || turboSp < 6000.0);
                        this.sLog.fine((Object)("turbo enable = " + enable + " turboPr = " + turboPr + " PRESS_TURBO_LOW =" + 5.0));
                    }
                    if (!Double.isNaN(turboPr)) {
                        turnOff = enable == false;
                    }
                    try {
                        devState = turboStateMap.get(((CryoTurboDevice)this.switchDevices[sw]).readTurboStatus());
                    }
                    catch (DriverException driverException) {}
                    break;
                }
                case 1: {
                    if (!Double.isNaN(cryoPr)) {
                        enable = cryoPr < 1.0E-6;
                        turnOff = cryoPr >= 1.0E-5;
                        break;
                    }
                    turnOff = true;
                    break;
                }
                case 11: {
                    enable = true;
                    break;
                }
                case 15: {
                    enable = true;
                    break;
                }
                case 12: {
                    enable = this.vacState.getSwitchState(11) == SwitchState.ON;
                    turnOff = enable == false;
                    break;
                }
                case 13: {
                    enable = this.vacState.getSwitchState(11) == SwitchState.ON;
                    turnOff = enable == false;
                    break;
                }
                case 14: {
                    enable = this.vacState.getSwitchState(11) == SwitchState.ON;
                    turnOff = enable == false;
                }
            }
            SwitchState oldState = this.vacState.getSwitchState(sw);
            if (turnOff && oldState == SwitchState.ON) {
                try {
                    this.setSwitch(sw, false);
                }
                catch (VacuumException e) {
                    this.sLog.error((Object)("Error setting switch: " + (Object)((Object)e)));
                }
            }
            SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
            SwitchEnable switchEnable = enabled = enable != false ? SwitchEnable.ON : SwitchEnable.OFF;
            if (state != oldState || enabled != this.vacState.getSwitchEnable(sw)) {
                this.sLog.info((Object)("Enabling switch sw=" + sw + " enabled = " + enabled));
                this.vacState.setSwitchState(sw, state);
                this.vacState.setSwitchEnable(sw, enabled);
                changed = true;
            }
            if (devState == this.vacState.getDeviceState(sw)) continue;
            this.vacState.setDeviceState(sw, devState);
            changed = true;
        }
        for (int cond = 0; cond < 8; ++cond) {
            ConditionState state;
            if (!this.vacState.hasCondition(cond)) continue;
            Boolean active = false;
            Boolean latched = false;
            if (this.plutoDevc != null) {
                active = this.plutoDevc.isConditionActive(cond);
                latched = this.plutoDevc.isConditionLatched(cond);
            }
            ConditionState conditionState = active == null || latched == null ? ConditionState.OFFLINE : (latched != false ? ConditionState.LATCHED : (state = active != false ? ConditionState.ACTIVE : ConditionState.CLEAR));
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        VacuumState vState = Double.isNaN(cryoPr) ? VacuumState.UNKNOWN : (cryoPr <= 1.0E-7 ? VacuumState.VACUUM : (this.vacState.getSwitchState(1) == SwitchState.ON ? VacuumState.ION_ON : (this.vacState.getSwitchEnable(1) == SwitchEnable.ON ? VacuumState.ION_OFF : (this.vacState.getSwitchState(0) == SwitchState.ON ? VacuumState.TURBO_ON : (this.vacState.getSwitchEnable(0) == SwitchEnable.ON ? VacuumState.TURBO_OFF : (cryoPr < 759.0 ? VacuumState.FORELINE : VacuumState.OFF))))));
        if (vState != this.vacState.getVacuumState()) {
            this.vacState.setVacuumState(vState);
            this.ass.updateAgentState(new Enum[]{vState});
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        if (alert.getAlertId().equals(ComCamVacuumAlerts.VACUUM_PLC_NOT_ALIVE.getAlertId())) {
            return this.plcActive ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ComCamVacuumState", (Serializable)this.getVacuumState()));
    }

    private void setTickPeriod(long period) {
        this.apts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.apts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    static {
        ComCamVacuumSubsystem.switchChannels[1] = 3;
        ComCamVacuumSubsystem.switchChannels[6] = 2;
        ComCamVacuumSubsystem.switchChannels[2] = 0;
        ComCamVacuumSubsystem.switchChannels[7] = 4;
        ComCamVacuumSubsystem.switchChannels[8] = 5;
        ComCamVacuumSubsystem.switchChannels[9] = 6;
        ComCamVacuumSubsystem.switchChannels[10] = 7;
        ComCamVacuumSubsystem.switchChannels[11] = 0;
        ComCamVacuumSubsystem.switchChannels[12] = RefrigerationConfig.CryoTelType.CRYO.ordinal();
        ComCamVacuumSubsystem.switchChannels[13] = RefrigerationConfig.CryoTelType.COLD1.ordinal();
        ComCamVacuumSubsystem.switchChannels[14] = RefrigerationConfig.CryoTelType.COLD2.ordinal();
        ComCamVacuumSubsystem.switchChannels[15] = 0;
        turboStateMap = new HashMap<TwisTorr84.PumpStatus, DeviceState>();
        turboStateMap.put(TwisTorr84.PumpStatus.STOP, DeviceState.STOPPED);
        turboStateMap.put(TwisTorr84.PumpStatus.WAIT_INTLK, DeviceState.WAITING);
        turboStateMap.put(TwisTorr84.PumpStatus.STARTING, DeviceState.STARTNG);
        turboStateMap.put(TwisTorr84.PumpStatus.NORMAL, DeviceState.NORMAL);
        turboStateMap.put(TwisTorr84.PumpStatus.BRAKING, DeviceState.BRAKING);
        turboStateMap.put(TwisTorr84.PumpStatus.FAIL, DeviceState.FAILED);
        turboStateMap.put(TwisTorr84.PumpStatus.AUTO_TUNING, DeviceState.AUTOTUN);
    }
}

