package org.lsst.ccs.subsystem.comcamvacuum;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.alert.AlertService;
//import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A class with information about ComCamVacuum alarms
 *
 * @author The LSST CCS Team
 */
public class ComCamVacuumAlertHandler implements Monitor.AlarmHandler {

    private static final Logger LOG = Logger.getLogger("org.lsst.ccs.subsystem.comcamvacuum.alarms");

    @LookupField(strategy = LookupField.Strategy.TREE)
    private AlertService alertService;

    @Override
    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        //Low plate temperature alarm 
/*
        if (parm == RaftAlert.REB_BOARD_TEMPERATURE_TOO_LOW.ordinal()) {
            switch (event) {
                //The Low Alarm treshold has been crossed.
                case Alarm.EVENT_TRIP:
                    LOG.severe("The plate temperature is below the low alarm limit");
                    break;
                case Alarm.EVENT_LIMBO_FROM_ERROR:
                    //In Warning band from Alarm
                    LOG.warning("The plate temperature was raised above the low warning limit");
                    break;
                case Alarm.EVENT_LIMBO_FROM_GOOD:
                    //In Warning band from Nominal
                    LOG.warning("The plate temperature has gone below the low warning limit");
                    break;
                case Alarm.EVENT_RESET:
                    //Back to Nominal
                    LOG.info("The plate temperature is back above the low warning limit");
                    break;
            }
            //No Alert was raised in this case so let the framework raise an alert
            return false;
        }

        //High plate temperature alarm         
        if (parm == RaftAlert.REB_BOARD_TEMPERATURE_TOO_HIGH.ordinal()) {
            AlertState state = AlertState.NOMINAL;
            switch (event) {
                //The High Alarm treshold has been crossed.
                case Alarm.EVENT_TRIP:
                    LOG.severe("The plate temperature is above the high alarm limit");
                    state = AlertState.ALARM;
                    break;
                case Alarm.EVENT_LIMBO_FROM_ERROR:
                    //In Warning band from Alarm
                    LOG.warning("The plate temperature has gone below the high warning limit");
                    state = AlertState.WARNING;
                    break;
                case Alarm.EVENT_LIMBO_FROM_GOOD:
                    //In Warning band from Nominal
                    LOG.warning("The plate temperature has gone above the high warning limit");
                    state = AlertState.WARNING;
                    break;
                case Alarm.EVENT_RESET:
                    //Back to Nominal
                    LOG.info("The plate temperature is back below the high warning limit");
                    state = AlertState.NOMINAL;
                    break;
            }
            alertService.raiseAlert(RaftAlert.REB_BOARD_TEMPERATURE_TOO_HIGH.getAlert(), state, alarmName + ": " + cause);
            return true;
        }
*/
        return false;
    }
    
    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
/*
        for ( RaftAlert raftAlert : RaftAlert.values() ) {
            if ( raftAlert.getAlertId().equals(alert.getAlertId() ) ) {
                getAlarmById(raftAlert.ordinal()).clearState();
                return ClearAlertCode.CLEAR_ALERT;
            }
        }
*/
        return ClearAlertCode.UNKWNOWN_ALERT;
    }
    
    
}
