/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.strategy;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.regions.EhcacheNaturalIdRegion;
import org.hibernate.cache.ehcache.internal.strategy.AbstractEhcacheAccessStrategy;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class TransactionalEhcacheNaturalIdRegionAccessStrategy
extends AbstractEhcacheAccessStrategy<EhcacheNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    private final Ehcache ehcache;

    public TransactionalEhcacheNaturalIdRegionAccessStrategy(EhcacheNaturalIdRegion region, Ehcache ehcache, SessionFactoryOptions settings) {
        super(region, settings);
        this.ehcache = ehcache;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) {
        return false;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) {
        return false;
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        try {
            Element element = this.ehcache.get(key);
            return element == null ? null : element.getObjectValue();
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region();
    }

    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        try {
            this.ehcache.put(new Element(key, value));
            return true;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    @Override
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        try {
            if (minimalPutOverride && this.ehcache.get(key) != null) {
                return false;
            }
            this.ehcache.put(new Element(key, value));
            return true;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void remove(SessionImplementor session, Object key) throws CacheException {
        try {
            this.ehcache.remove(key);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
    }

    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        try {
            this.ehcache.put(new Element(key, value));
            return true;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SessionImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues((Object)cacheKey);
    }
}

