/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.freehep.jas.plugin.basic.FileOpener;
import org.freehep.swing.JDirectoryChooser;

class FileOpenPreferences
extends JPanel {
    private JButton browseButton;
    private JTextField directoryTextField;
    private JRadioButton rememberButton;
    private FileOpener fileOpener;

    FileOpenPreferences(FileOpener opener) {
        this.fileOpener = opener;
        this.initComponents();
        this.setEnabled(null);
    }

    boolean apply() {
        this.fileOpener.setDefaultDirectory(this.directoryTextField.getText());
        this.fileOpener.setRestoreLastDirectoryUsed(this.rememberButton.isSelected());
        return true;
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel jLabel1 = new JLabel();
        this.rememberButton = new JRadioButton();
        JRadioButton defaultButton = new JRadioButton();
        this.directoryTextField = new JTextField();
        this.browseButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        jLabel1.setText("When opening files start file chooser in:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel1, gridBagConstraints);
        this.rememberButton.setText("Last directory used");
        this.rememberButton.setSelected(this.fileOpener.isRestoreLastDirectoryUsed());
        buttonGroup.add(this.rememberButton);
        this.rememberButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileOpenPreferences.this.setEnabled(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.rememberButton, gridBagConstraints);
        defaultButton.setText("User specified directory");
        defaultButton.setSelected(!this.fileOpener.isRestoreLastDirectoryUsed());
        buttonGroup.add(defaultButton);
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileOpenPreferences.this.setEnabled(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)defaultButton, gridBagConstraints);
        this.directoryTextField.setColumns(20);
        this.directoryTextField.setText(this.fileOpener.getDefaultDirectory());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.directoryTextField, gridBagConstraints);
        this.browseButton.setText("Browse...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileOpenPreferences.this.browseButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.browseButton, new GridBagConstraints());
    }

    private void setEnabled(ActionEvent evt) {
        boolean enabled = !this.rememberButton.isSelected();
        this.browseButton.setEnabled(enabled);
        this.directoryTextField.setEnabled(enabled);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JDirectoryChooser chooser = new JDirectoryChooser();
        try {
            chooser.setCurrentDirectory(new File(this.directoryTextField.getText()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        int rc = chooser.showDialog((Component)this);
        if (rc == 0) {
            this.directoryTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }
}

