/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class XSkewSelectionPanel
extends AbstractRegionSelectionPanel {
    private static final int STARTING_WIDTH = 25;

    @Override
    public int getNumberOfControlPoints() {
        return 6;
    }

    @Override
    public Cursor getControlPointCursor(int index) {
        int k;
        switch (index) {
            case 0: 
            case 3: {
                k = 4;
                break;
            }
            case 1: 
            case 2: {
                k = 5;
                break;
            }
            case 4: 
            case 5: {
                return FreeHepImage.getCursor("0_MoveCursor", 16, 16);
            }
            default: {
                return FreeHepImage.getCursor("XSkewCursor");
            }
        }
        return XSkewSelectionPanel.compassCursor("Resize", this.xCtrlPts[index] - this.xCtrlPts[k], this.yCtrlPts[index] - this.yCtrlPts[k], 4, false);
    }

    @Override
    public void initializeControlPoints(int x, int y) {
        this.activeCtrlPt = 5;
        Arrays.fill(this.xCtrlPts, x);
        this.yCtrlPts[0] = y - 25;
        this.yCtrlPts[1] = y - 25;
        this.yCtrlPts[2] = y + 25;
        this.yCtrlPts[3] = y + 25;
        this.yCtrlPts[4] = y;
        this.yCtrlPts[5] = y;
    }

    @Override
    public void updateActiveControlPoint(int x, int y) {
        x = this.forceXCoordinateWithinBounds(x);
        y = this.forceYCoordinateWithinBounds(y);
        switch (this.activeCtrlPt) {
            case 0: {
                int width = y - this.yCtrlPts[4];
                this.yCtrlPts[0] = this.yCtrlPts[4] + width;
                this.yCtrlPts[1] = this.yCtrlPts[5] + width;
                this.yCtrlPts[2] = this.yCtrlPts[5] - width;
                this.yCtrlPts[3] = this.yCtrlPts[4] - width;
                break;
            }
            case 1: {
                int width = y - this.yCtrlPts[5];
                this.yCtrlPts[0] = this.yCtrlPts[4] + width;
                this.yCtrlPts[1] = this.yCtrlPts[5] + width;
                this.yCtrlPts[2] = this.yCtrlPts[5] - width;
                this.yCtrlPts[3] = this.yCtrlPts[4] - width;
                break;
            }
            case 2: {
                int width = y - this.yCtrlPts[5];
                this.yCtrlPts[0] = this.yCtrlPts[4] - width;
                this.yCtrlPts[1] = this.yCtrlPts[5] - width;
                this.yCtrlPts[2] = this.yCtrlPts[5] + width;
                this.yCtrlPts[3] = this.yCtrlPts[4] + width;
                break;
            }
            case 3: {
                int width = y - this.yCtrlPts[4];
                this.yCtrlPts[0] = this.yCtrlPts[4] - width;
                this.yCtrlPts[1] = this.yCtrlPts[5] - width;
                this.yCtrlPts[2] = this.yCtrlPts[5] + width;
                this.yCtrlPts[3] = this.yCtrlPts[4] + width;
                break;
            }
            case 4: {
                int width = this.yCtrlPts[4] - this.yCtrlPts[0];
                this.xCtrlPts[this.activeCtrlPt] = x;
                this.yCtrlPts[this.activeCtrlPt] = y;
                this.xCtrlPts[0] = x;
                this.yCtrlPts[0] = y - width;
                this.xCtrlPts[3] = x;
                this.yCtrlPts[3] = y + width;
                break;
            }
            case 5: {
                int width = this.yCtrlPts[4] - this.yCtrlPts[0];
                this.xCtrlPts[this.activeCtrlPt] = x;
                this.yCtrlPts[this.activeCtrlPt] = y;
                this.xCtrlPts[1] = x;
                this.yCtrlPts[1] = y - width;
                this.xCtrlPts[2] = x;
                this.yCtrlPts[2] = y + width;
                break;
            }
        }
        this.repaintPanel();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(thickStroke);
            g.setColor(Color.black);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            g2d.setStroke(thinStroke);
            g.setColor(Color.white);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            if (this.activeCtrlPt >= 0) {
                g.setColor(Color.black);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, 2 * ctrlPtSize + 3, 2 * ctrlPtSize + 3);
                g.setColor(Color.white);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize, 2 * ctrlPtSize + 1, 2 * ctrlPtSize + 1);
            }
        }
    }

    @Override
    public AffineTransform makeAffineTransform() {
        int first = 0;
        int xSavedValue = this.xCtrlPts[first];
        int ySavedValue = this.yCtrlPts[first];
        for (int i = 1; i < 4; ++i) {
            int xValue = this.xCtrlPts[i];
            int yValue = this.yCtrlPts[i];
            if (xValue < xSavedValue) {
                xSavedValue = xValue;
                ySavedValue = yValue;
                first = i;
                continue;
            }
            if (xValue != xSavedValue || yValue >= ySavedValue) continue;
            xSavedValue = xValue;
            ySavedValue = yValue;
            first = i;
        }
        int third = (first + 2) % 4;
        int dx0 = this.xCtrlPts[third] - this.xCtrlPts[first];
        int second = (first + 1) % 4;
        int dy1 = this.yCtrlPts[second] - this.yCtrlPts[first];
        int dy0 = this.yCtrlPts[third] - this.yCtrlPts[first];
        int dx1 = this.xCtrlPts[second] - this.xCtrlPts[first];
        if (dx0 * dy1 - dy0 * dx1 > 0) {
            second = (first + 3) % 4;
        }
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    @Override
    public boolean isValidSelection() {
        return this.visible && this.xCtrlPts[4] != this.xCtrlPts[5] && this.yCtrlPts[0] != this.yCtrlPts[3];
    }
}

