/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.concurrent.CancellationException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPage;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

final class MonitorPageDialog
extends JDialog {
    private final String defaultName = "Monitor";
    private boolean nameNotEdited = true;
    private final PersistenceService service = Console.getConsole().getSingleton(PersistenceService.class);
    private PersistableMonitorView view;
    private PersistableAgentChannelsFilter filter;
    private MonitorPage.Descriptor descriptor;
    private MonitorPage page;
    private JTextField nameField;
    private JTextField viewField;
    private JTextField filterField;

    private MonitorPageDialog(MonitorPage.Descriptor before, String title, Component parent) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), title == null ? "Open new monitoring page" : title, Dialog.ModalityType.APPLICATION_MODAL);
        this.descriptor = before;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 8, 3, 8);
        c.anchor = 13;
        c.gridx = 0;
        c.gridy = 0;
        JLabel label = new JLabel("Page name:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.gridy = 1;
        label = new JLabel("View type:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.gridy = 2;
        label = new JLabel("Filter:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        this.nameField = new JTextField("Monitor", 50);
        this.nameField.addCaretListener(e -> {
            if (this.nameNotEdited) {
                this.nameNotEdited = false;
            }
        });
        gridbag.setConstraints(this.nameField, c);
        this.add(this.nameField);
        c.gridy = 1;
        this.viewField = new JTextField("Default view", 50);
        this.viewField.setEditable(false);
        gridbag.setConstraints(this.viewField, c);
        this.add(this.viewField);
        c.gridy = 2;
        this.filterField = new JTextField("Unfiltered", 50);
        this.filterField.setEditable(false);
        gridbag.setConstraints(this.filterField, c);
        this.add(this.filterField);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.gridy = 1;
        JButton button = new JButton("...");
        button.setToolTipText("Select view type");
        button.addActionListener(e -> {
            PersistableMonitorView v = (PersistableMonitorView)this.service.make(this.descriptor.getView(), title, parent, "MonitorView");
            if (v != null) {
                this.view = v;
                String name = this.view.getName();
                if (name == null || name.trim().isEmpty()) {
                    Class<?> viewClass = this.view.getClass();
                    ConsoleLookup cl = viewClass.getAnnotation(ConsoleLookup.class);
                    if (cl != null) {
                        name = cl.name();
                    }
                    if (name == null || name.isEmpty()) {
                        name = viewClass.getSimpleName();
                    }
                } else if (this.nameNotEdited && this.nameField.getText().equals("Monitor")) {
                    this.nameField.setText(name);
                }
                this.viewField.setText(name);
            }
        });
        gridbag.setConstraints(button, c);
        this.add(button);
        c.gridy = 2;
        button = new JButton("...");
        button.setToolTipText("Select filter");
        button.addActionListener(e -> {
            PersistenceService serv = Console.getConsole().getSingleton(PersistenceService.class);
            this.filter = (AbstractChannelsFilter)serv.make(null, "Select filter", this, "AgentChannelsFilter");
            if (this.filter == null) {
                this.filterField.setText("Unfiltered");
            } else {
                String name = this.filter.getName();
                if (name == null || name.isEmpty()) {
                    this.filterField.setText(this.filter.getClass().getSimpleName());
                } else {
                    this.filterField.setText(name);
                    if (this.nameNotEdited) {
                        this.nameField.setText(name);
                    }
                }
            }
        });
        gridbag.setConstraints(button, c);
        this.add(button);
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 14;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.insets = new Insets(16, 8, 4, 8);
        JPanel box = new JPanel();
        box.setLayout(new GridLayout(1, 2, 16, 5));
        button = new JButton("Cancel");
        button.addActionListener(e -> {
            this.view = null;
            this.filter = null;
            this.page = null;
            this.dispose();
            throw new CancellationException();
        });
        box.add(button);
        button = new JButton("OK");
        button.addActionListener(e -> {
            if (this.done()) {
                this.dispose();
            }
        });
        box.add(button);
        gridbag.setConstraints(box, c);
        this.add(box);
    }

    static MonitorPage edit(MonitorPage page, String title, Component parentComponent) {
        MonitorPage.Descriptor before = page == null ? null : page.save();
        MonitorPageDialog dialog = new MonitorPageDialog(before, title, parentComponent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        return dialog.page;
    }

    private boolean done() {
        Persistable.Descriptor desc;
        if (this.view == null) {
            desc = this.descriptor.getView();
            this.view = desc == null ? new DefaultView() : (PersistableMonitorView)this.service.make(desc);
        }
        if (this.view == null) {
            return false;
        }
        if (this.filter == null) {
            desc = this.descriptor.getFilter();
            this.filter = desc == null ? (PersistableAgentChannelsFilter)AgentChannelsFilter.ALL : (PersistableAgentChannelsFilter)this.service.make(desc);
        }
        String name = this.nameField.getText();
        try {
            this.page = new MonitorPage(this.view, this.filter, name);
        }
        catch (RuntimeException x) {
            return false;
        }
        return true;
    }
}

