/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo.persist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;

public class TestFilter
extends AbstractChannelsFilter {
    private final String name;
    private final List<String> agents;
    private final List<String> channels;
    private final String delimeter;
    private final boolean agentTabs;
    private final List<String> fields;
    private HashMap<String, String> display2origin;

    @Create(category="org.lsst.ccs.gconsole.agent.AgentChannelsFilter", name="Test Filter", path="Built-In/Test/Generic", description="Channels filter that allows the user to specify lists of accepted agents and channels.")
    public TestFilter(@Par(desc="Filter name. Optional.") String name, @Par(desc="Comma-separated list of subsystems accepted by this filter") String agents, @Par(desc="Comma-separated list of channels accepted by this filter (may contain templates and selectors)") String channels, @Par(desc="Character in the original channel path that should be replaced by a slash (and therefore used as a path delimeter). This is a very long parameter description indeed, without any html markup") String delimeter, @Par(desc="If true, the subsystem name is used as a page name.") boolean separatePagesForAgents, @Par(desc="Comma-separated list of fields to display in monitor views.") String fields) {
        String[] ss;
        this.name = name;
        if (agents.trim().isEmpty()) {
            this.agents = null;
        } else if (agents.trim().equals("\"\"")) {
            this.agents = Collections.emptyList();
        } else {
            ss = agents.split(",");
            this.agents = new ArrayList<String>(ss.length);
            for (String s : ss) {
                this.agents.add(s.trim());
            }
        }
        if (channels.trim().isEmpty()) {
            this.channels = null;
        } else if (channels.trim().equals("\"\"")) {
            this.channels = Collections.emptyList();
        } else {
            ss = channels.split(",");
            this.channels = new ArrayList<String>(ss.length);
            for (String s : ss) {
                this.channels.add(s.trim());
            }
        }
        if (delimeter.isEmpty()) {
            this.delimeter = null;
        } else {
            String s = delimeter.trim();
            this.delimeter = s.length() > 2 && s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : Pattern.quote(delimeter);
            this.display2origin = new HashMap();
        }
        this.agentTabs = separatePagesForAgents;
        if (fields == null || fields.trim().isEmpty()) {
            this.fields = null;
        } else if (fields.equals("\"\"")) {
            this.fields = Collections.singletonList("VALUE");
        } else {
            ss = fields.split(",");
            this.fields = new ArrayList<String>(ss.length);
            for (String s : ss) {
                this.fields.add(s.trim());
            }
        }
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        String displayPath;
        if (this.delimeter == null) {
            displayPath = this.agentTabs ? originPath.replaceFirst("/", "//") : originPath;
        } else {
            int i = originPath.indexOf("/");
            String agent = originPath.substring(0, i);
            String localPath = originPath.substring(i + 1);
            localPath = localPath.replaceAll(this.delimeter, "/");
            displayPath = this.agentTabs ? agent + "//" + localPath : agent + "/" + localPath;
            this.display2origin.putIfAbsent(displayPath, originPath);
        }
        return Collections.singletonList(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        if (this.delimeter == null) {
            if (this.agentTabs) {
                return displayPath.replaceFirst("//", "/");
            }
            return displayPath;
        }
        return this.display2origin.get(displayPath);
    }

    @Override
    public List<String> getOriginChannels() {
        return this.channels;
    }

    @Override
    public List<String> getAgents() {
        return this.agents;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getFields(boolean compact) {
        return compact ? null : this.fields;
    }

    @Create(category="org.lsst.ccs.gconsole.agent.AgentChannelsFilter", name="Test Filter - States", path="Built-In/Test/States", description="Channels filter that display states.")
    public static TestFilter statesOnly(@Par(desc="Comma-separated list of subsystems accepted by this filter. Optional") String agents) {
        return new TestFilter("States", agents, "/state/", null, false, null);
    }
}

