/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.data;

import java.io.Serializable;

public class ComCamVacuumConfig
implements Serializable {
    public static final String[] COMPONENT_NAMES = new String[]{"IDLE", "READY", "TEST", "ACQ1", "WARM"};
    public static int MAXSTATES = operating_states.values().length;
    private int cfgstate = 0;
    private double[] biasVAcq = new double[MAXSTATES];
    private double[] cryoTAcq = new double[MAXSTATES];
    private double[] vacPAcq = new double[MAXSTATES];
    private double[] lambdaAcq = new double[MAXSTATES];
    private String[] filter_names;
    private double[] filter_edges = new double[6];
    private String srctype;
    private String monotype;
    private String pdtype;
    private String biastype;
    private int pdcnt = 0;
    private double pdnplc = 1.0;
    private int biason;
    private double[] minLmpPwr = new double[MAXSTATES];
    private double[] cryoTAcqTol = new double[MAXSTATES];
    private String configFile;

    public ComCamVacuumConfig() {
    }

    public ComCamVacuumConfig(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.update(biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.update(this.cfgstate, biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(int istate, double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.biasVAcq[istate] = biasVAcq;
        this.cryoTAcq[istate] = cryoTAcq;
        this.cryoTAcqTol[istate] = cryoTAcqTol;
        this.vacPAcq[istate] = vacPAcq;
        this.lambdaAcq[istate] = lambdaAcq;
        this.minLmpPwr[istate] = minLmpPwr;
    }

    public double getBiasVAcq() {
        return this.biasVAcq[this.cfgstate];
    }

    public double getCryoTAcq() {
        return this.cryoTAcq[this.cfgstate];
    }

    public void setCryoTAcq(double cryoTAcq, int istate) {
        this.cryoTAcq[istate] = cryoTAcq;
    }

    public double getVacPAcq() {
        return this.vacPAcq[this.cfgstate];
    }

    public double getLambdaAcq() {
        return this.lambdaAcq[this.cfgstate];
    }

    public String[] getFilters() {
        return this.filter_names;
    }

    public String getSrcType() {
        return this.srctype;
    }

    public String getMonoType() {
        return this.monotype;
    }

    public String getPDType() {
        return this.pdtype;
    }

    public String getBIASType() {
        return this.biastype;
    }

    public int getPDcnt() {
        return this.pdcnt;
    }

    public void setPDcnt(int pdcnt) {
        this.pdcnt = pdcnt;
    }

    public double getPDnplc() {
        return this.pdnplc;
    }

    public void setPDnplc(double pdnplc) {
        this.pdnplc = pdnplc;
    }

    public int getBiason() {
        return this.biason;
    }

    public void setBiason(int biason) {
        this.biason = biason;
    }

    public double getMinLmpPwr() {
        return this.minLmpPwr[this.cfgstate];
    }

    public void setCryoTAcqTol(double cryoTAcqTol) {
        this.cryoTAcqTol[this.cfgstate] = cryoTAcqTol;
    }

    public double getCryoTAcqTol() {
        return this.cryoTAcqTol[this.cfgstate];
    }

    public void setCfgState(int cfgstate) {
        this.cfgstate = cfgstate;
    }

    public int getCfgstate() {
        return this.cfgstate;
    }

    public double[] getFilter_edges() {
        return this.filter_edges;
    }

    public void setFilter_edges(double[] filter_edges) {
        this.filter_edges = filter_edges;
    }

    public void setBiasVAcq(double biasVAcq) {
        this.biasVAcq[this.cfgstate] = biasVAcq;
    }

    public void setBiasVAcq(double biasVAcq, int istate) {
        this.biasVAcq[istate] = biasVAcq;
    }

    public void setCryoTAcq(double cryoTAcq) {
        this.cryoTAcq[this.cfgstate] = cryoTAcq;
    }

    public void setVacPAcq(double vacPAcq) {
        this.vacPAcq[this.cfgstate] = vacPAcq;
    }

    public void setLambdaAcq(double lambdaAcq) {
        this.lambdaAcq[this.cfgstate] = lambdaAcq;
    }

    public void setFilter_names(String[] filter_names) {
        this.filter_names = filter_names;
    }

    public void setSrctype(String srctype) {
        this.srctype = srctype;
    }

    public void setMonotype(String monotype) {
        this.monotype = monotype;
    }

    public void setPdtype(String pdtype) {
        this.pdtype = pdtype;
    }

    public void setBiastype(String biastype) {
        this.biastype = biastype;
    }

    public void setMinLmpPwr(double minLmpPwr) {
        this.minLmpPwr[this.cfgstate] = minLmpPwr;
    }

    public String toString() {
        Object line = "";
        for (operating_states stat : operating_states.values()) {
            int icfg = stat.ordinal();
            line = (String)line + "state=" + stat.name() + ", biasVAcq=" + this.biasVAcq[icfg] + ", cryoTAcq=" + this.cryoTAcq[icfg] + ", vacPAcq=" + this.vacPAcq[icfg] + ", lambdaAcq=" + this.lambdaAcq[icfg];
        }
        line = (String)line + ", filter_names=" + this.filter_names + ", srctype=" + this.srctype + ", monotype=" + this.monotype + ", pdtype=" + this.pdtype + ", biastype=" + this.biastype;
        return line;
    }

    public static enum operating_states {
        IDLE,
        READY,
        TEST,
        ACQ1,
        WARM,
        ACQ3,
        ACQ4,
        ACQ5,
        EXPERT;

    }

    public static enum CryoTelType {
        CRYO,
        COLD1,
        COLD2;

    }

    public static enum EVENT_ID {
        BIAS,
        CRYO,
        VAC,
        PD,
        LMP;

    }
}

