/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.ui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelSingle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

public class ComCamVacuumPage {
    private final AgentInfo agent;
    private final String VHX_UTT_GCC_00 = "";
    private final String VCR_UTT_GCC_00 = "main/CryoVacGauge/CryoVac";
    private final String VHX_UTT_GCC_01 = "";
    private final String VCR_UTT_GHF_00 = "main/TurboVacGauge/TurboVac";
    private final String VCR_UTT_GCC_02 = "";
    private final String VHX_UUT_VGC_01 = "";
    private final String VCR_UTT_VGC_00 = "";
    private final String L3_O_RING = "";
    private final String L3_HOUSING_0_RING = "";
    private final String FEEDTHRU_RING_O_RING = "";
    private final String PUMP_PLATE_0_RING = "";
    private final String[] VCR_UTT_PIP_00 = new String[]{"main/IonPumps/CIP1_V", "main/IonPumps/CIP1_I"};
    private final String[] VCR_UTT_PIP_01 = new String[]{"main/IonPumps/CIP2_V", "main/IonPumps/CIP2_I"};
    private final String[] VCR_UTT_PIP_02 = new String[]{"main/IonPumps/CIP3_V", "main/IonPumps/CIP3_I"};
    private final String[] VHX_UTT_PIP_03 = new String[]{"", ""};
    private final String[] VHX_UTT_PIP_04 = new String[]{"", ""};
    private final String[] VCR_UTT_PIP_05 = new String[]{"", ""};
    private final String[] VCR_UTT_PIP_06 = new String[]{"main/IonPumps/CIP4_V", "main/IonPumps/CIP4_I"};
    private final String[] VCR_UTT_PIP_07 = new String[]{"main/IonPumps/CIP5_V", "main/IonPumps/CIP5_I"};
    private final String[] VCR_UTT_PIP_08 = new String[]{"main/IonPumps/CIP6_V", "main/IonPumps/CIP6_I"};
    private final String VHX_UTT_PTM_01 = "";
    private final String VCR_UTT_PTM_00 = "main/TurboPump/TurboSpeed";
    private ImageView view;
    private final MonitorField gaugeField;
    private final MonitorField maField;
    private final MonitorField lsField;
    private final MonitorField rpmField;
    private final MonitorField valveField;

    public ComCamVacuumPage(AgentInfo agent) {
        this.agent = agent;
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = 0;
        fv.format = "<html><center>%1$6.1e<br>Torr";
        this.gaugeField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$6.2f ma";
        this.maField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$7.1f V";
        this.lsField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$6.0f rpm";
        this.rpmField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "open";
        this.valveField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
    }

    public ImageView getView() {
        if (this.view != null) {
            return this.view;
        }
        try {
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/subsystem/comcamvacuum/ui/vacuum.png"));
            this.view = new ImageView("Vacuum", back, 0.5, 2.0);
            this.placeGauge(0.4231, 0.082, "");
            this.placeGauge(0.3739, 0.273, "main/CryoVacGauge/CryoVac");
            this.placeGauge(0.5572, 0.257, "");
            this.placeGauge(0.5203, 0.4696, "main/TurboVacGauge/TurboVac");
            this.placeValve(0.5055, 0.3338, "", 0.5f, 1.0f);
            this.placeValve(0.3469, 0.4936, "", 0.5f, 1.0f);
            this.placeValve(0.0701, 0.8628, "", 1.0f, 0.5f);
            this.placeValve(0.1562, 0.8586, "", 1.0f, 0.5f);
            this.placeValve(0.2312, 0.8614, "", 1.0f, 0.5f);
            this.placeValve(0.3137, 0.8586, "", 1.0f, 0.5f);
            this.placeMa(0.5351, 0.1655, this.VHX_UTT_PIP_04, 0.0f, 0.5f);
            this.placeMa(0.5166, 0.6393, this.VHX_UTT_PIP_03, 0.0f, 0.5f);
            this.placeMa(0.4096, 0.7624, this.VCR_UTT_PIP_05, 0.5f, 0.0f);
            this.placeRpm(0.5879, 0.3585, "");
            this.placeRpm(0.5855, 0.5203, "main/TurboPump/TurboSpeed");
            FormattedValue fv = new FormattedValue();
            fv.horizontalAlignment = 0;
            fv.format = "%2$d x %1$7.1f V";
            MonitorField.Average ipVField = new MonitorField.Average(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            fv.format = "%1$6.2f mA";
            MonitorField.Average ipIField = new MonitorField.Average(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            String[][] pumps = new String[][]{this.VCR_UTT_PIP_00, this.VCR_UTT_PIP_01};
            ArrayList<DisplayChannelSingle> chV = new ArrayList<DisplayChannelSingle>(pumps.length);
            ArrayList<DisplayChannelSingle> chI = new ArrayList<DisplayChannelSingle>(pumps.length);
            for (String[] ss : pumps) {
                chV.add(new DisplayChannelSingle(this.agent.getName() + "/" + ss[0], null, null));
                chI.add(new DisplayChannelSingle(this.agent.getName() + "/" + ss[1], null, null));
            }
            DefaultMonitorCell c0 = new DefaultMonitorCell(chV, (MonitorField)ipVField);
            DefaultMonitorCell c1 = new DefaultMonitorCell(chI, (MonitorField)ipIField);
            CellTableView table = new CellTableView(2, 1, new DefaultMonitorCell[]{c0, c1});
            ImageView.Item item = new ImageView.Item((Object)table);
            item.setPosition(0.3124, 0.3946);
            item.setAlignment(0.0, 0.5);
            item.setMaxSize(0.242, 0.082);
            this.view.add(item);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.view;
    }

    private void placeGauge(double x, double y, String ch) throws IOException {
        DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/" + ch, null, null), this.gaugeField);
        CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment(0.5, 0.5);
        item.setMaxSize(0.085, 0.055);
        this.view.add(item);
    }

    private void placeValve(double x, double y, String ch, float horAlign, float vertAlign) throws IOException {
        DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/" + ch, null, null), this.valveField);
        CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment((double)horAlign, (double)vertAlign);
        item.setMaxSize(0.242, 0.082);
        this.view.add(item);
    }

    private void placeMa(double x, double y, String[] ch, float horAlign, float vertAlign) throws IOException {
        DefaultMonitorCell c0 = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/" + ch[0], null, null), this.maField);
        DefaultMonitorCell c1 = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/" + ch[1], null, null), this.lsField);
        CellTableView table = new CellTableView(2, 1, new DefaultMonitorCell[]{c0, c1});
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment((double)horAlign, (double)vertAlign);
        item.setMaxSize(0.242, 0.082);
        this.view.add(item);
    }

    private void placeRpm(double x, double y, String ch) throws IOException {
        DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/" + ch, null, null), this.rpmField);
        CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment(0.0, 0.5);
        item.setMaxSize(0.1132, 0.0382);
        this.view.add(item);
    }
}

