/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.histogram.binner.Binner1D;

public abstract class AbstractBinner1D
implements Binner1D {
    protected int[] entries;
    protected double[] binCenter;
    protected double[] sumW;
    protected double[] sumWW;
    protected double[] sumXW;
    protected double[] sumXXW;
    protected int bins;

    public AbstractBinner1D(int bins) {
        if (bins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + bins);
        }
        this.setNumberOfBins(bins);
    }

    public AbstractBinner1D(Binner1D binner) {
        if (binner.bins() < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + this.bins);
        }
        this.initBinner(binner);
    }

    public void initBinner(Binner1D binner) {
        this.setNumberOfBins(binner.bins());
        int e = 0;
        double h = 0.0;
        double er = 0.0;
        double m = 0.0;
        double w = 0.0;
        double r = 0.0;
        for (int i = 0; i < this.bins; ++i) {
            this.setBinCenter(i, binner.binCenter(i));
            e = binner.entries(i);
            h = binner.height(i);
            w = binner.sumWW(i);
            m = binner.sumXW(i);
            r = binner.sumXXW(i);
            this.entries[i] = e;
            if (HistUtils.isValidDouble(h)) {
                this.sumW[i] = h;
            }
            if (HistUtils.isValidDouble(w)) {
                this.sumWW[i] = w;
            }
            if (HistUtils.isValidDouble(m)) {
                this.sumXW[i] = m;
            }
            if (!HistUtils.isValidDouble(r)) continue;
            this.sumXXW[i] = r;
        }
    }

    protected void createArrays(int n) {
        this.entries = new int[n];
        this.binCenter = new double[n];
        this.sumW = new double[n];
        this.sumWW = new double[n];
        this.sumXW = new double[n];
        this.sumXXW = new double[n];
    }

    private void setNumberOfBins(int bins) {
        this.bins = bins;
        this.createArrays(bins);
    }

    public String toString() {
        String tmp = "";
        for (int i = 0; i < this.bins; ++i) {
            tmp = tmp + i + "  b=" + this.binCenter(i) + ", e=" + this.entries(i) + ",  h=" + this.height(i) + ",  m=" + this.mean(i) + ",  r=" + this.rms(i) + "\n";
        }
        tmp = tmp + "\n";
        return tmp;
    }

    public void setBinCenter(int bin, double x) {
        this.binCenter[bin] = x;
        this.entries[bin] = 0;
        this.sumW[bin] = 0.0;
        this.sumWW[bin] = 0.0;
        this.sumXW[bin] = 0.0;
        this.sumXXW[bin] = 0.0;
    }

    @Override
    public double binCenter(int bin) {
        return this.binCenter[bin];
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bins; ++i) {
            this.binCenter[i] = 0.0;
            this.entries[i] = 0;
            this.sumW[i] = 0.0;
            this.sumWW[i] = 0.0;
            this.sumXW[i] = 0.0;
            this.sumXXW[i] = 0.0;
        }
    }

    @Override
    public int bins() {
        return this.bins;
    }

    @Override
    public void fill(int bin, double x, double weight) {
        double delta = x - this.binCenter[bin];
        int n = bin;
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.sumW[n2] = this.sumW[n2] + weight;
        int n3 = bin;
        this.sumWW[n3] = this.sumWW[n3] + weight * weight;
        int n4 = bin;
        this.sumXW[n4] = this.sumXW[n4] + delta * weight;
        int n5 = bin;
        this.sumXXW[n5] = this.sumXXW[n5] + delta * delta * weight;
    }

    @Override
    public int entries(int bin) {
        return this.entries[bin];
    }

    @Override
    public double height(int bin) {
        return this.sumW[bin];
    }

    @Override
    public double mean(int bin) {
        double h = this.height(bin);
        if (h != 0.0) {
            return this.sumXW[bin] / h;
        }
        return Double.NaN;
    }

    @Override
    public double rms(int bin) {
        double h = this.height(bin);
        double m = this.sumXW[bin];
        double r = this.sumXXW[bin];
        if (h != 0.0) {
            return Math.sqrt(Math.abs((r - m * m / h) / h));
        }
        return Double.NaN;
    }

    @Override
    public void scale(double scaleFactor) {
        int bin = 0;
        while (bin < this.bins) {
            int n = bin;
            this.sumW[n] = this.sumW[n] * scaleFactor;
            int n2 = bin;
            this.sumWW[n2] = this.sumWW[n2] * (scaleFactor * scaleFactor);
            int n3 = bin;
            this.sumXW[n3] = this.sumXW[n3] * scaleFactor;
            int n4 = bin++;
            this.sumXXW[n4] = this.sumXXW[n4] * scaleFactor;
        }
    }

    @Override
    public double sumWW(int bin) {
        return this.sumWW[bin];
    }

    @Override
    public double sumXW(int bin) {
        return this.sumXW[bin];
    }

    @Override
    public double sumXXW(int bin) {
        return this.sumXXW[bin];
    }

    @Override
    public void setBinContent(int bin, double binCenter, int entries, double height, double plusError, double minusError, double sWW, double sXW, double sXXW) {
        this.entries[bin] = entries;
        this.sumW[bin] = !Double.isNaN(height) ? height : (double)entries;
        this.sumWW[bin] = !Double.isNaN(sWW) ? sWW : (!Double.isNaN(plusError) ? plusError * plusError : (double)entries);
        double d = binCenter - this.binCenter(bin);
        if (d != 0.0) {
            sXXW += d * (2.0 * sXW + d * this.sumW[bin]);
            sXW += d * this.sumW[bin];
        }
        this.sumXW[bin] = sXW;
        this.sumXXW[bin] = sXXW;
    }
}

