/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;

public class AgentStatusEvent
extends EventObject {
    protected final List<AgentInfo> agents;
    protected final StatusMessage message;
    protected final Map<AgentChannel, List<String>> statusChanges;
    protected final List<AgentChannel> addedChannels;
    protected final List<AgentChannel> removedChannels;

    AgentStatusEvent(AgentStatusAggregator aggregator, List<AgentInfo> agents, StatusMessage message, Map<AgentChannel, List<String>> statusChanges, List<AgentChannel> addedChannels, List<AgentChannel> removedChannels) {
        super(aggregator);
        this.agents = agents == null && message != null ? Collections.singletonList(message.getOriginAgentInfo()) : agents;
        this.message = message;
        this.statusChanges = statusChanges == null ? Collections.emptyMap() : statusChanges;
        this.addedChannels = addedChannels == null ? Collections.emptyList() : addedChannels;
        this.removedChannels = removedChannels == null ? Collections.emptyList() : removedChannels;
    }

    @Override
    public AgentStatusAggregator getSource() {
        return (AgentStatusAggregator)this.source;
    }

    public List<AgentInfo> getAgents() {
        return this.agents;
    }

    public List<String> getAgentNames() {
        return this.agents.stream().map(a -> a.getName()).collect(Collectors.toList());
    }

    public StatusMessage getMessage() {
        return this.message;
    }

    public Map<AgentChannel, List<String>> getStatusChanges() {
        return this.statusChanges;
    }

    public List<AgentChannel> getAddedChannels() {
        return this.addedChannels;
    }

    public List<AgentChannel> getRemovedChannels() {
        return this.removedChannels;
    }

    public boolean isEmpty() {
        return this.statusChanges.isEmpty() && this.addedChannels.isEmpty() && this.removedChannels.isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SA event: ");
        sb.append("[").append(String.join((CharSequence)",", this.agents.stream().map(a -> a.getName()).collect(Collectors.toList()))).append("] ");
        if (!this.addedChannels.isEmpty()) {
            sb.append("Added ").append(this.addedChannels.size()).append(" ");
        }
        if (!this.removedChannels.isEmpty()) {
            sb.append("Removed ").append(this.removedChannels.size()).append(" ");
        }
        if (!this.statusChanges.isEmpty()) {
            sb.append("Changed ").append(this.statusChanges.size()).append(" ");
        }
        return sb.toString();
    }
}

