/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.influxdb.dto.Point;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.utils.InfluxDbClientService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.cluster.monitor.Accumulate;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.python.netty.util.internal.ConcurrentSet;

public class BusTrafficMonitor
implements HasLifecycle,
AgentPresenceListener {
    private static final Object counterLock = new Object();
    private static final Logger LOG_INFLUX = Logger.getLogger(BusTrafficMonitor.class.getName() + ".influx");
    private static final Logger LOG_MSG = Logger.getLogger(BusTrafficMonitor.class.getName() + ".messages");
    private static final Logger LOG_APL = Logger.getLogger(BusTrafficMonitor.class.getName() + ".apl");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    private static final HashMap<UUID, CommandMsg> commands = new HashMap();
    private static BlockingQueue<Runnable> statusQueue = null;
    private static BlockingQueue<Runnable> commandQueue = null;
    private static BlockingQueue<Runnable> logQueue = null;
    private Thread statusThread;
    private Thread commandThread;
    private Thread logThread;
    private final CommandBusCounterListener commandBusListener = new CommandBusCounterListener();
    private final StatusBusCounterListener statusBusListener = new StatusBusCounterListener();
    private final LogBusCounterListener logBusListener = new LogBusCounterListener();
    private Map<String, CCSTimeStamp> disconnectedAgents = new ConcurrentHashMap<String, CCSTimeStamp>();
    private static Map<Tags, Integer> agentCountersMap = new ConcurrentHashMap<Tags, Integer>();
    private static Map<Tags, Map<String, Accumulate>> tagsAccumMap = new ConcurrentHashMap<Tags, Map<String, Accumulate>>();

    public void build() {
        this.agentPropertiesService.setAgentProperty("org.lsst.ccs.use.full.paths", "true");
        AgentPeriodicTask resetCounterAndPublish = new AgentPeriodicTask("busTrafficStatsUpdate", () -> this.resetCounterAndPublish()).withPeriod(Duration.ofSeconds(60L));
        ((AgentPeriodicTaskService)this.agent.getAgentService(AgentPeriodicTaskService.class)).scheduleAgentPeriodicTask(resetCounterAndPublish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounters() {
        Thread oldStatusThread = this.statusThread;
        Thread oldCommandThread = this.commandThread;
        Thread oldLogThread = this.logThread;
        Object object = counterLock;
        synchronized (object) {
            agentCountersMap = new ConcurrentHashMap<Tags, Integer>();
            tagsAccumMap = new ConcurrentHashMap<Tags, Map<String, Accumulate>>();
            if (statusQueue != null) {
                statusQueue.add(new DoneWork());
                commandQueue.add(new DoneWork());
                logQueue.add(new DoneWork());
            }
            statusQueue = new LinkedBlockingQueue<Runnable>();
            commandQueue = new LinkedBlockingQueue<Runnable>();
            logQueue = new LinkedBlockingQueue<Runnable>();
            this.statusThread = new MyQueueWorker(statusQueue);
            this.commandThread = new MyQueueWorker(commandQueue);
            this.logThread = new MyQueueWorker(logQueue);
            this.statusThread.start();
            this.commandThread.start();
            this.logThread.start();
        }
        try {
            if (oldStatusThread != null) {
                oldStatusThread.join();
            }
            if (oldCommandThread != null) {
                oldCommandThread.join();
            }
            if (oldLogThread != null) {
                oldLogThread.join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public void start() {
        this.resetCounters();
        this.agent.getMessagingAccess().addCommandMessageListener((CommandMessageListener)this.commandBusListener);
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.statusBusListener);
        this.agent.getMessagingAccess().addLogMessageListener((LogMessageListener)this.logBusListener);
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void shutdown() {
        this.agent.getMessagingAccess().removeCommandMessageListener((CommandMessageListener)this.commandBusListener);
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.statusBusListener);
        this.agent.getMessagingAccess().removeLogMessageListener((LogMessageListener)this.logBusListener);
        this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void connecting(AgentInfo ... agents) {
        LOG_APL.log(Level.FINE, "Connecting Agents: {0}", Arrays.asList(agents));
    }

    public void connected(AgentInfo ... agents) {
        LOG_APL.log(Level.FINE, "Connected Agents: {0}", Arrays.asList(agents));
        HashMap<String, Duration> reconnected = new HashMap<String, Duration>();
        for (AgentInfo agent : agents) {
            String agentName = agent.getName();
            CCSTimeStamp ts = this.disconnectedAgents.remove(agentName);
            if (ts == null) continue;
            reconnected.put(agentName, Duration.between(ts.getUTCInstant(), CCSTimeStamp.currentTime().getUTCInstant()));
        }
        if (!reconnected.isEmpty()) {
            String msg = "Reconnected agents: ";
            for (String agent : reconnected.keySet()) {
                msg = msg + agent + " (" + ((Duration)reconnected.get(agent)).getSeconds() + "s) ";
            }
            LOG_APL.log(Level.WARNING, msg);
            if (this.disconnectedAgents.isEmpty()) {
                ((AlertService)this.agent.getAgentService(AlertService.class)).raiseAlert(new Alert("clusterSplit", "Alert raised when the CCS cluster splits"), AlertState.NOMINAL, "All missing agents have rejoined the cluster.");
            } else {
                ((AlertService)this.agent.getAgentService(AlertService.class)).raiseAlert(new Alert("clusterSplit", "Alert raised when the CCS cluster splits"), AlertState.WARNING, "The following agents are still missing: " + this.disconnectedAgents.keySet());
            }
        }
    }

    public void disconnected(AgentInfo ... agents) {
        LOG_APL.log(agents.length < 2 ? Level.FINE : Level.WARNING, "Disconnecting Agent: {0}", Arrays.asList(agents));
        if (agents.length >= 2) {
            ((AlertService)this.agent.getAgentService(AlertService.class)).raiseAlert(new Alert("clusterSplit", "Alert raised when the CCS cluster splits"), AlertState.WARNING, "These agents left the cluster: " + Arrays.asList(agents));
            CCSTimeStamp now = CCSTimeStamp.currentTime();
            for (AgentInfo agent : agents) {
                this.disconnectedAgents.put(agent.getName(), now);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounterAndPublish() {
        ConcurrentSet allTags;
        Map<Tags, Map<String, Accumulate>> agentTimeAccumulatorsMapOld;
        Map<Tags, Integer> agentCountersMapOld;
        Object object = counterLock;
        synchronized (object) {
            agentCountersMapOld = agentCountersMap;
            agentTimeAccumulatorsMapOld = tagsAccumMap;
        }
        this.resetCounters();
        if (this.influxDbClientService != null && this.influxDbClientService.getInfluxDbClient() != null) {
            Point.Builder pointBuilder;
            allTags = new ConcurrentSet();
            allTags.addAll(agentCountersMapOld.keySet());
            allTags.addAll(agentTimeAccumulatorsMapOld.keySet());
            HashMap<String, Integer> typeCount = new HashMap<String, Integer>();
            long time = System.currentTimeMillis();
            ArrayList<String> alreadyCountedAgentName = new ArrayList<String>();
            for (Tags tags : allTags) {
                if (tags.bus == Bus.STATUS) {
                    AgentInfo.AgentType type = tags.agentInfo.getType();
                    if (!alreadyCountedAgentName.contains(tags.agentInfo.getName())) {
                        Integer currentCount;
                        alreadyCountedAgentName.add(tags.agentInfo.getName());
                        Integer n = currentCount = typeCount.getOrDefault(type.name(), 0);
                        currentCount = currentCount + 1;
                        Integer n2 = currentCount;
                        typeCount.put(type.name(), currentCount);
                    }
                }
                pointBuilder = Point.measurement((String)"cluster_metrics").time(time, TimeUnit.MILLISECONDS);
                Integer counter = agentCountersMapOld.get(tags);
                if (counter != null) {
                    pointBuilder = pointBuilder.addField("traffic", (Number)counter);
                }
                Map<String, Accumulate> accumMap = agentTimeAccumulatorsMapOld.get(tags);
                for (String key : accumMap.keySet()) {
                    Accumulate accum = accumMap.get(key);
                    if (accum.getCounts() <= 0) continue;
                    pointBuilder = pointBuilder.addField(key + "_avg", accum.getAverageValue()).addField(key + "_max", accum.getMaxValue()).addField(key + "_min", accum.getMinValue()).addField(key + "_tot", accum.getTotalValue());
                }
                if (!pointBuilder.hasFields()) continue;
                AgentInfo.AgentType agentType = tags.agentInfo.getType();
                String agentName = tags.agentInfo.getName();
                Point point = pointBuilder.tag("bus", tags.bus.name()).tag("agent", agentName).tag("host", tags.agentInfo.getAgentProperty("org.lsst.ccs.agent.hostname", "")).tag("user", tags.agentInfo.getAgentProperty("org.lsst.ccs.agent.username", "")).tag("msgType", tags.messageType).tag("type", agentType.name()).tag(this.influxDbClientService.getGlobalTags()).build();
                LOG_INFLUX.fine("Writing to influxDb " + point);
                this.influxDbClientService.getInfluxDbClient().write(point);
            }
            for (Map.Entry entry : typeCount.entrySet()) {
                pointBuilder = Point.measurement((String)"cluster_metrics").time(time, TimeUnit.MILLISECONDS);
                if (!(pointBuilder = pointBuilder.addField("agent_count", (Number)entry.getValue())).hasFields()) continue;
                Point point = pointBuilder.tag("type", (String)entry.getKey()).tag(this.influxDbClientService.getGlobalTags()).build();
                this.influxDbClientService.getInfluxDbClient().write(point);
            }
        } else {
            allTags = new ConcurrentSet();
            allTags.addAll(agentCountersMapOld.keySet());
            allTags.addAll(agentTimeAccumulatorsMapOld.keySet());
            KeyValueDataList dataList = new KeyValueDataList("cluster_metrics");
            HashMap<String, Integer> allCounters = new HashMap<String, Integer>();
            for (Tags tag : allTags) {
                String busName = tag.bus.name();
                String string = tag.messageType;
                String agentName = tag.agentInfo.getType() == AgentInfo.AgentType.CONSOLE ? "console" : tag.agentInfo.getName();
                Integer counter = agentCountersMapOld.get(tag);
                if (counter != null) {
                    dataList.addData("traffic/" + busName + "/" + string + "/" + agentName, (Serializable)counter);
                    allCounters.put(busName, allCounters.getOrDefault(busName, 0) + counter);
                }
                Map<String, Accumulate> accumMap = agentTimeAccumulatorsMapOld.get(tag);
                for (String key : accumMap.keySet()) {
                    Accumulate accum = accumMap.get(key);
                    if (accum.getCounts() <= 0) continue;
                    dataList.addData(key + "_avg/" + busName + "/" + string + "/" + agentName, (Serializable)Double.valueOf(accum.getAverageValue()));
                    dataList.addData(key + "_max/" + busName + "/" + string + "/" + agentName, (Serializable)Double.valueOf(accum.getMaxValue()));
                    dataList.addData(key + "_min/" + busName + "/" + string + "/" + agentName, (Serializable)Double.valueOf(accum.getMinValue()));
                }
            }
            for (String busName : allCounters.keySet()) {
                dataList.addData("traffic/" + busName + "/all", (Serializable)allCounters.get(busName));
            }
            this.agent.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
        }
    }

    private static void incrementAgentCounter(Tags tags) {
        Integer agentCounter = agentCountersMap.get(tags);
        if (agentCounter == null) {
            agentCounter = 0;
        }
        agentCounter = agentCounter + 1;
        agentCountersMap.put(tags, agentCounter);
    }

    private static void incrementAgentKeyAccumulator(Tags tags, String key, double value) {
        Accumulate accum;
        Map<String, Accumulate> keyAccumMap = tagsAccumMap.get(tags);
        if (keyAccumMap == null) {
            keyAccumMap = new HashMap<String, Accumulate>();
            tagsAccumMap.put(tags, keyAccumMap);
        }
        if ((accum = keyAccumMap.get(key)) == null) {
            accum = new Accumulate();
            keyAccumMap.put(key, accum);
        }
        accum.accumulate(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processBusMessage(Bus bus, BusMessage msg, CCSTimeStamp received) {
        AgentInfo agentInfo = msg.getOriginAgentInfo();
        Tags tags = new Tags(bus, agentInfo, msg);
        MsgInfo msgInfo = new MsgInfo(msg, received);
        Object object = counterLock;
        synchronized (object) {
            BusTrafficMonitor.incrementAgentCounter(tags);
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "process_out", msgInfo.getOutboundProcessingTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "serialization", msgInfo.getSerializationTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "transfer", msgInfo.getNetworkTransferTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "deserialization", msgInfo.getDeserializationTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "process_in", msgInfo.getInboundProcessingTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "transfer_total", msgInfo.getTotalTransferTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "size", msgInfo.getSize());
        }
        if (msg instanceof StatusMessage) {
            if (!(msg instanceof StatusHeartBeat)) {
                Level logLevel = msgInfo.getTotalTransferTime() > 50L ? Level.INFO : Level.FINE;
                LOG_MSG.log(logLevel, "{0}", new Object[]{BusTrafficMonitor.getMessageInfoStr(msgInfo)});
                LOG_MSG.log(Level.FINER, "{0}", msg);
            }
        } else if (msg instanceof CommandMessage) {
            CommandMsg existingMsg;
            CommandMessage cmdMsg = (CommandMessage)msg;
            UUID corrId = cmdMsg.getCorrelationId();
            if (cmdMsg instanceof CommandRequest) {
                commands.put(corrId, new CommandMsg(msgInfo));
            } else if (msg instanceof CommandAck) {
                CommandMsg existingMsg2 = commands.get(corrId);
                if (existingMsg2 != null) {
                    existingMsg2.setAck(msgInfo);
                }
            } else if ((msg instanceof CommandNack || msg instanceof CommandResult) && (existingMsg = commands.remove(corrId)) != null) {
                existingMsg.logCommandMsg(msgInfo);
            }
        }
    }

    public static double sizeOf(Serializable object) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException ieo) {
            return 0.0;
        }
        return (double)byteOutputStream.toByteArray().length / 1000.0;
    }

    private static String getMessageInfoStr(MsgInfo msgInfo) {
        BusMessage msg = msgInfo.msg;
        if (msg instanceof CommandRequest) {
            CommandRequest request = (CommandRequest)msg;
            return String.format("Command Request to " + request.getDestination() + " from " + request.getOriginAgentInfo().getName() + ": " + request.getBasicCommand().getCommand() + " (" + msgInfo.getTotalTransferTime() + " ms, " + msgInfo.getSize() + " Kb)", new Object[0]);
        }
        if (msg instanceof CommandReply) {
            String header = "unknown";
            if (msg instanceof CommandAck) {
                header = "Command Ack";
            } else if (msg instanceof CommandNack) {
                header = "Command Nack";
            } else if (msg instanceof CommandResult) {
                header = "Command Result";
            }
            return String.format(header + ": (" + msgInfo.getTotalTransferTime() + " ms, " + msgInfo.getSize() + " Kb)", new Object[0]);
        }
        if (msg instanceof StatusMessage) {
            return String.format("Status " + msg.getClass().getSimpleName() + " from " + msg.getOriginAgentInfo().getName() + ": (" + msgInfo.getTotalTransferTime() + " ms, " + msgInfo.getSize() + " Kb)", new Object[0]);
        }
        return "";
    }

    private static class CommandMsg {
        private final MsgInfo msgInfo;
        private MsgInfo ack;

        CommandMsg(MsgInfo msgInfo) {
            this.msgInfo = msgInfo;
        }

        void setAck(MsgInfo ack) {
            this.ack = ack;
        }

        void logCommandMsg(MsgInfo finalReply) {
            Level logLevel;
            long totalCmdExecution = Duration.between(this.msgInfo.msg.getCCSTimeStamp().getUTCInstant(), finalReply.received.getUTCInstant()).toMillis();
            Level level = logLevel = totalCmdExecution > 50L ? Level.INFO : Level.FINE;
            if (this.ack != null) {
                LOG_MSG.log(logLevel, "{0}\n{1}\n{2}\n{3}", new Object[]{BusTrafficMonitor.getMessageInfoStr(this.msgInfo), BusTrafficMonitor.getMessageInfoStr(this.ack), BusTrafficMonitor.getMessageInfoStr(finalReply), "Total Command Execution: " + totalCmdExecution + " ms"});
            } else {
                LOG_MSG.log(logLevel, "{0}\n{1}\n{2}", new Object[]{BusTrafficMonitor.getMessageInfoStr(this.msgInfo), BusTrafficMonitor.getMessageInfoStr(finalReply), "Total Command Execution: " + totalCmdExecution + " ms"});
            }
        }
    }

    private static class MsgInfo {
        private final BusMessage msg;
        private final long totalTransferTime;
        private final long networkTransferTime;
        private final long outboundProcessingTime;
        private final long inboundProcessingTime;
        private final long serializationTime;
        private final long deserializationTime;
        private final CCSTimeStamp received;
        private final double size;

        MsgInfo(BusMessage msg, CCSTimeStamp received) {
            this.msg = msg;
            this.received = received;
            this.totalTransferTime = Duration.between(msg.getCCSTimeStamp().getUTCInstant(), received.getUTCInstant()).toMillis();
            this.networkTransferTime = msg.getTransferDuration() != null ? msg.getTransferDuration().toMillis() : 0L;
            this.outboundProcessingTime = msg.getSerializationTime() != null ? Duration.between(msg.getCCSTimeStamp().getUTCInstant(), msg.getSerializationTime().getUTCInstant()).toMillis() : 0L;
            this.inboundProcessingTime = msg.getDoneDeSerializationTime() != null ? Duration.between(msg.getDoneDeSerializationTime().getUTCInstant(), received.getUTCInstant()).toMillis() : -1L;
            this.serializationTime = msg.getSerializationDuration() != null ? msg.getSerializationDuration().toMillis() : -1L;
            this.deserializationTime = msg.getDeserializationDuration() != null ? msg.getDeserializationDuration().toMillis() : -1L;
            this.size = BusTrafficMonitor.sizeOf((Serializable)msg);
        }

        public long getTotalTransferTime() {
            return this.totalTransferTime;
        }

        public long getNetworkTransferTime() {
            return this.networkTransferTime;
        }

        public long getOutboundProcessingTime() {
            return this.outboundProcessingTime;
        }

        public long getInboundProcessingTime() {
            return this.inboundProcessingTime;
        }

        public long getSerializationTime() {
            return this.serializationTime;
        }

        public long getDeserializationTime() {
            return this.deserializationTime;
        }

        public double getSize() {
            return this.size;
        }

        public CCSTimeStamp getReceivedTimestamp() {
            return this.received;
        }
    }

    private class DoneWork
    implements Runnable {
        private DoneWork() {
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class MyQueueWorker
    extends Thread {
        private final BlockingQueue<Runnable> queue;

        public MyQueueWorker(BlockingQueue<Runnable> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                Runnable r;
                while (!((r = this.queue.take()) instanceof DoneWork)) {
                    r.run();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class StatusBusCounterListener
    implements StatusMessageListener {
        private StatusBusCounterListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            statusQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.STATUS, (BusMessage)msg, CCSTimeStamp.currentTime()));
        }
    }

    private static class LogBusCounterListener
    implements LogMessageListener {
        private LogBusCounterListener() {
        }

        public void onLogMessage(LogMessage msg) {
            logQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.LOG, (BusMessage)msg, CCSTimeStamp.currentTime()));
        }
    }

    private static class CommandBusCounterListener
    implements CommandMessageListener {
        private CommandBusCounterListener() {
        }

        public void onCommandMessage(CommandMessage msg) {
            commandQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.COMMAND, (BusMessage)msg, CCSTimeStamp.currentTime()));
        }
    }

    private static class Tags {
        private final Bus bus;
        private final AgentInfo agentInfo;
        private final String messageType;

        Tags(Bus bus, AgentInfo agentInfo, BusMessage msg) {
            this.bus = bus;
            this.agentInfo = agentInfo;
            String msgSimpleName = msg.getClass().getSimpleName();
            if (msg instanceof StatusMessage) {
                this.messageType = msgSimpleName;
            } else if (msg instanceof CommandMessage) {
                this.messageType = msg instanceof CommandRequest ? msgSimpleName + "-" + ((CommandRequest)msg).getBasicCommand().getCommand() : msgSimpleName;
            } else if (msg instanceof LogMessage) {
                this.messageType = msgSimpleName + "-" + ((LogMessage)msg).getLoggerName() + "-" + ((LogMessage)msg).getLevel();
            } else {
                throw new RuntimeException("Unknown message " + msg);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Tags) {
                Tags t1 = (Tags)obj;
                return t1.bus.equals((Object)this.bus) && t1.agentInfo.equals((Object)this.agentInfo) && t1.messageType.equals(this.messageType);
            }
            return false;
        }

        public int hashCode() {
            return this.bus.hashCode() + 34 * this.agentInfo.hashCode() + 123 * this.messageType.hashCode();
        }
    }
}

