/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentAlerts;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMBeanService;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.cluster.monitor.CustomClusterProbe;

public class JGroupsViewMonitor
implements HasLifecycle,
AgentMonitor,
ClearAlertHandler {
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentMBeanService mbeanService;
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.jgroup.monitor");
    private String diagnosticAddress = null;

    public void init() {
        this.diagnosticAddress = BootstrapResourceUtils.getBootstrapProperties((String)"udp_ccs").getProperty("org.lsst.ccs.jgroups.ALL.UDP.diagnostics_addr", "224.0.75.75");
    }

    public String getAgentMonitorDescription() {
        return "JGroups Cluster View Monitor";
    }

    public synchronized String getAgentMonitorStatus(boolean useCcsBuses) {
        CustomClusterProbe p = new CustomClusterProbe(this.diagnosticAddress);
        p.probeCluster(new String[0]);
        Collection<CustomClusterProbe.ClusterInfo> clusters = p.getClusters();
        StringBuilder probeAlertBuffer = new StringBuilder();
        boolean clusterViewOk = true;
        for (CustomClusterProbe.ClusterInfo cluster : clusters) {
            this.log.debug((Object)("Checking view for " + cluster.clusterName));
            HashMap viewsInCluster = new HashMap();
            StringBuilder sb = new StringBuilder();
            for (CustomClusterProbe.ClusterMemberInfo clusterMemberInfo : cluster) {
                String clusterUniqueId = clusterMemberInfo.viewName + "|" + clusterMemberInfo.viewId + " (" + clusterMemberInfo.viewSize + ")";
                if (!viewsInCluster.containsKey(clusterUniqueId)) {
                    viewsInCluster.put(clusterUniqueId, new ArrayList());
                }
                ((List)viewsInCluster.get(clusterUniqueId)).add(clusterMemberInfo);
            }
            for (Map.Entry entry : viewsInCluster.entrySet()) {
                sb.append("View: ").append((String)entry.getKey()).append(" [");
                for (CustomClusterProbe.ClusterMemberInfo member : (List)entry.getValue()) {
                    sb.append(member.getMemberName()).append(" ");
                }
                sb.append("]\n");
            }
            if (viewsInCluster.size() > 1) {
                clusterViewOk = false;
                sb = new StringBuilder("Too many views in Cluster: ").append(cluster.clusterName).append("\n").append((CharSequence)sb);
                this.log.warn((Object)sb);
                probeAlertBuffer.append((CharSequence)sb);
                continue;
            }
            this.log.debug((Object)sb);
        }
        if (useCcsBuses) {
            if (!clusterViewOk) {
                ((AlertService)this.agent.getAgentService(AlertService.class)).raiseAlert(AgentAlerts.ClusterViewAlert.getAlert(null), AlertState.ALARM, probeAlertBuffer.toString());
            } else {
                RaisedAlertHistory history = ((AlertService)this.agent.getAgentService(AlertService.class)).getRaisedAlertSummary().getRaisedAlert(AgentAlerts.ClusterViewAlert.getAlertId());
                if (history != null && history.getLatestAlertInstance().getAlertState() != AlertState.NOMINAL) {
                    ((AlertService)this.agent.getAgentService(AlertService.class)).raiseAlert(AgentAlerts.ClusterViewAlert.getAlert(null), AlertState.NOMINAL, "Cluster is back to normal.");
                }
            }
        }
        return probeAlertBuffer.toString().isEmpty() ? "OK" : probeAlertBuffer.toString();
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        String alertId = alert.getAlertId();
        if (alertId.equals(AgentAlerts.ClusterViewAlert.getAlertId())) {
            return this.getAgentMonitorStatus(false).equals("OK") ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    public static void main(String[] argv) {
        JGroupsViewMonitor monitor = new JGroupsViewMonitor();
        String result = monitor.getAgentMonitorStatus(false);
        System.out.println("\nResult of probing the cluster: ");
        System.out.println(result);
    }
}

