/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import org.lsst.ccs.Agent;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.services.AgentService;

public final class AgentSignalHandlerService
implements AgentService,
ServiceLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private ComponentLookup lookup;

    @Override
    public String getAgentServiceName() {
        return "signalHandlerService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void preInit() {
        this.lookup = this.agent.getComponentLookup();
        boolean useFullPaths = "true".equals(this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
        this.agent.addCommandsFromObject(new AgentSignalHandlingCommandsForAgent(), "");
        TreeWalkerUtils.proceduralWalk(this.lookup, null, SignalHandler.class, sh -> {
            String componentFullPath = this.lookup.getComponentNodeForObject(sh).getPath();
            if (!useFullPaths && componentFullPath.equals("main")) {
                this.agent.getLogger().warning((Object)"Skipping SignalHandler component main when adding commands.");
            } else {
                this.agent.addCommandsFromObject(new AgentSignalHandlingCommandsForInnerNode(sh), componentFullPath);
            }
        }, null);
    }

    public class AgentSignalHandlingCommandsForInnerNode {
        private final ComponentNode rootNode;

        AgentSignalHandlingCommandsForInnerNode(Object rootObject) {
            this.rootNode = AgentSignalHandlerService.this.lookup.getComponentNodeForObject(rootObject);
        }

        @Command(description="Abort current action", type=Command.CommandType.SIGNAL)
        public void abort() {
            AgentSignalHandlerService.this.agent.getLogger().fine((Object)("Agent " + AgentSignalHandlerService.this.agent.getName() + ": abort requested"));
            this.internalSendSignal(new Signal(SignalLevel.HALT));
        }

        @Command(description="Stop current action with an expected max delay", type=Command.CommandType.SIGNAL)
        public void stop(@Argument(name="timeHint", defaultValue="-1") long timeHint) throws HardwareException {
            AgentSignalHandlerService.this.agent.getLogger().fine((Object)("Agent " + AgentSignalHandlerService.this.agent.getName() + ": stop requested with " + timeHint));
            this.internalSendSignal(new Signal(SignalLevel.STOP, timeHint));
        }

        private void internalSendSignal(Signal signal) {
            TreeWalkerUtils.treeWalk(AgentSignalHandlerService.this.agent.getComponentLookup(), this.rootNode, SignalHandler.class, sh -> sh.signal(signal), null);
        }
    }

    public class AgentSignalHandlingCommandsForAgent
    extends AgentSignalHandlingCommandsForInnerNode {
        AgentSignalHandlingCommandsForAgent() {
            super(AgentSignalHandlerService.this.agent);
        }

        @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
        public void stopAndWait(long timeHint) throws HardwareException, InterruptedException {
            this.stop(timeHint);
            int step = 10;
            long fracDelay = timeHint / (long)step;
            HardwareException lastExc = null;
            for (int i = 0; i < step; ++i) {
                try {
                    Thread.sleep(fracDelay);
                    AgentSignalHandlerService.this.agent.checkAllHardwareStopped();
                    return;
                }
                catch (HardwareException e) {
                    lastExc = e;
                    continue;
                }
            }
            throw lastExc;
        }
    }
}

