/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.remote.CCSBusesConfigurationDAO;
import org.lsst.ccs.config.remote.DualConfigurationDAO;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ConfigurationService
implements ServiceLifecycle,
ClearAlertHandler,
AgentPresenceListener,
AgentService,
HasDataProviderInfos {
    private ConfigurationDAO configurationProxy;
    private ConfigurationInfo currentConfigInfo;
    private ConfigurationHandlerSet configurationHandler;
    private final Set<String> categories = new HashSet<String>();
    private static final Logger conf_sub_log = Logger.getLogger((String)"org.lsst.ccs.config");
    private static final Alert CS_ALERT_1 = new Alert("CCSCFGSRV", "configuration service unavailable");
    private static final Alert CS_ALERT_2 = new Alert("CCSCFGOP", "operator error");
    private final Lock configLock = new ReentrantLock();
    private final Map<String, ComponentConfigurationEnvironment> keyEnvironmentMap = new HashMap<String, ComponentConfigurationEnvironment>();
    private String descriptionName;
    private String agentName;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    private boolean useFullPaths = false;

    @Override
    public String getAgentServiceName() {
        return "configurationService";
    }

    @Override
    public void preBuild() {
        if (BootstrapResourceUtils.getBootstrapSystemProperties().getOrDefault((Object)"org.lsst.ccs.config.remote", "false").equals("true")) {
            this.agent.setAgentProperty("org.lsst.ccs.config.remote", "true");
        }
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        if (CS_ALERT_1.getAlertId().equals(alert.getAlertId())) {
            return this.configurationProxy.isAvailable() ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        if (CS_ALERT_2.getAlertId().equals(alert.getAlertId())) {
            return this.stateService.isInState((Enum)ConfigurationState.CONFIGURED) ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    @Override
    public void preInit() {
        this.useFullPaths = "true".equals(this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
        this.configurationHandler = new ConfigurationHandlerSet();
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode topNode = lookup.getTopComponentNode();
        TreeWalkerUtils.proceduralNodeWalk(lookup, null, n -> {
            String nodeName = this.useFullPaths ? n.getPath() : n.getKey();
            Object component = n.getComponent();
            if (this.configurationHandler.addConfigurationHandlerForObject(nodeName, n.getPath(), component)) {
                ComponentConfigurationEnvironment cce = new ComponentConfigurationEnvironment(nodeName, this);
                this.keyEnvironmentMap.put(nodeName, cce);
                this.agent.addCommandsFromObject(cce, n.getPath());
            }
        }, null);
        String descName = (String)topNode.getTag("descriptionName");
        this.descriptionName = descName == null ? this.agent.getClass().getSimpleName() : descName;
        this.agentName = this.agent.getName();
        this.configurationProxy = new LocalConfigurationDAO(this.agent.getName(), this.descriptionName);
        ConfigurationView initialView = new ConfigurationView();
        Map topNodeTags = topNode.getTags();
        for (Map.Entry entry : topNodeTags.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            try {
                String value = TypeUtils.stringify(entry.getValue());
                ParameterPath path = ParameterPath.valueOf((String)((String)entry.getKey()));
                if (!this.isParameterConfigurable(path.getComponentName(), path.getParameterName())) continue;
                initialView.putParameterValue(path.toString(), value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.categories.addAll(this.configurationHandler.getCategorySet());
        ConfigurationView safeValuesFromFile = this.configurationProxy.loadConfiguration(this.agentName, ConfigurationDescription.safeConfiguration(this.categories));
        initialView.putAll(safeValuesFromFile);
        this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, initialView);
    }

    @Override
    public void preStart() {
        this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo);
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        if (this.agent.getAgentInfo().hasAgentProperty("org.lsst.ccs.config.remote")) {
            conf_sub_log.debug((Object)"switching to remote configuration service");
            this.configurationProxy = new CCSBusesConfigurationDAO(this.agent.getMessagingAccess());
        }
        if (this.agent.getAgentInfo().hasAgentProperty("org.lsst.ccs.config.dual")) {
            conf_sub_log.debug((Object)"switching to dual configuration service");
            ComponentLookup lookup = this.agent.getComponentLookup();
            ComponentNode topNode = lookup.getTopComponentNode();
            String descName = (String)topNode.getTag("descriptionName");
            this.descriptionName = descName == null ? this.agent.getClass().getSimpleName() : descName;
            this.configurationProxy = new DualConfigurationDAO(this.agent.getMessagingAccess(), this.descriptionName);
        }
        new Thread(() -> {
            conf_sub_log.fine((Object)("*** getting ready to load startup configuration " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"))));
            try {
                this.stateService.waitFor(b -> b.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            conf_sub_log.fine((Object)("*** loading startup configuration " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"))));
            String startupConfig = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("startupConfig");
            if (startupConfig != null) {
                try {
                    conf_sub_log.fine((Object)("***  startup configuration  is " + startupConfig + " " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"))));
                    this.loadConfiguration(startupConfig.isEmpty() ? null : startupConfig.split(","));
                }
                catch (Exception ex) {
                    conf_sub_log.severe((Object)"could not load startup configuration", (Throwable)ex);
                    conf_sub_log.info((Object)("*** failure at " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"))));
                }
            }
        }).start();
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        return this.configurationHandler.getDataPoviderInfoList();
    }

    @Override
    public void publishDataProviderCurrentData() {
        this.publishConfigurationInfo();
    }

    @Command
    public String getConfigurationParameterValue(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        StringBuilder sb = new StringBuilder();
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        return (String)view.getValuesForComponent(componentName).get(parameterName);
    }

    @Command
    public String printConfigurationParameters() {
        StringBuilder sb = new StringBuilder();
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        Map values = view.getAsParameterPathMap();
        for (Map.Entry e : values.entrySet()) {
            sb.append(e.getKey()).append(" ").append((String)e.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public void saveAllChanges() {
        this.saveAllChanges(null);
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public void saveAllChanges(String configName) {
        ConfigurationDescription cd = this.getPartialConfigurationDescription(this.categories.toArray(new String[1]));
        cd.setName(configName, -1);
        this.saveChangesForCategoriesInternal(cd);
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public void saveChangesForCategories(String ... categories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            ConfigurationDescription cd = this.getPartialConfigurationDescription(categories);
            this.saveChangesForCategoriesInternal(cd);
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public void saveChangesForCategoriesAs(String ... taggedCategories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            ConfigurationDescription cd = new ConfigurationDescription(this.categories);
            cd.parseConfigurationString(taggedCategories);
            this.saveChangesForCategoriesInternal(cd);
        }
    }

    private void saveChangesForCategoriesInternal(ConfigurationDescription configDesc) {
        this.checkValidStates(true, true);
        if (configDesc.isEmpty()) {
            return;
        }
        try {
            ConfigurationView currentView = this.configurationHandler.getLiveConfigurationView();
            ConfigurationView diff = this.extractConfigurationViewFromCurrentConfigurationInfo().diff(currentView);
            if (!diff.isEmpty()) {
                StringBuilder sb = new StringBuilder("the following parameters have had their value changed without notifying the configuration service : \n");
                for (ParameterPath parm : diff.getAsParameterPathMap().keySet()) {
                    sb.append(parm).append(" expected ").append(this.currentConfigInfo.getCurrentValueForParameter(parm.toString())).append(" was ").append(currentView.getPathValue(parm)).append("\n");
                }
                throw new BulkSettingException(sb.toString());
            }
            currentView.setConfigurationDescription(configDesc);
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(currentView);
            ConfigurationDescription desc = this.configurationProxy.saveChangesForCategoriesAs(this.agentName, configDesc, ciBuilder.build());
            ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
    }

    private ConfigurationDescription getPartialConfigurationDescription(String ... categories) {
        ConfigurationDescription configDesc = new ConfigurationDescription(this.categories);
        for (String cat : categories) {
            configDesc.putTagForCategory(cat, this.currentConfigInfo.getConfigNameForCategory(cat), this.currentConfigInfo.getConfigVersion(cat));
        }
        return configDesc;
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION)
    public void dropAllChanges() {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void dropChangesForCategories(String ... categories) {
        HashSet<String> catSet = new HashSet<String>();
        catSet.addAll(Arrays.asList(categories));
        this.dropChangesInternal(catSet);
    }

    private void dropChangesInternal(Set<String> categories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true, true);
            try {
                ConfigurationView view = new ConfigurationView(this.getPartialConfigurationDescription(categories.toArray(new String[1])));
                for (ConfigurationParameterInfo cpi : this.currentConfigInfo.getAllParameterInfo()) {
                    if (!categories.contains(cpi.getCategoryName())) continue;
                    view.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getConfiguredValue());
                }
                ConfigurationView res = this.configurationHandler.loadCategories(view);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(String ... taggedCategories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(false, false);
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(taggedCategories).withDefaults(true);
            this.loadCategoriesInternal(configDesc);
        }
    }

    @Command(description="loads all categories for a given configuration", type=Command.CommandType.CONFIGURATION)
    public void loadGlobalConfiguration(@Argument(description="a name that defines a combination of tagegd categories") String globalName, int version) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(false, false);
            ConfigurationView configView = this.configurationProxy.loadGlobalConfiguration(this.agentName, globalName, version);
            if (!configView.getConfigurationDescription().getCategoryTags().keySet().containsAll(this.categories)) {
                throw new IllegalArgumentException("the named configuration " + globalName + "does not define a named configuration for all categories");
            }
            try {
                ConfigurationView res = this.configurationHandler.loadCategories(configView);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void loadCategories(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true, true);
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(taggedCategories);
            this.loadCategoriesInternal(configDesc);
        }
    }

    private void loadCategoriesInternal(ConfigurationDescription configDesc) {
        try {
            ConfigurationView cv = this.configurationProxy.loadConfiguration(this.agentName, configDesc);
            ConfigurationView res = this.configurationHandler.loadCategories(cv);
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
            ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
            ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.QUERY)
    public ConfigurationInfo getConfigurationInfo() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            ConfigurationInfo configurationInfo = this.currentConfigInfo;
            return configurationInfo;
        }
    }

    public void setReadOnlyParameter(String componentName, String parameterName, Object value) {
        if (!this.isParameterReadOnly(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a read-only configuration parameter");
        }
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value, true);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="publish a ConfigurationInfo object", type=Command.CommandType.QUERY)
    public void publishConfigurationInfo() {
        this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.getConfigurationInfo(), this.stateService.getState()));
    }

    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION)
    public void change(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        this.checkValidStates(true, true);
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a configuration parameter");
        }
        if (this.isParameterReadOnly(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter");
        }
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    public List<String> getAllConfigurableComponents() {
        ArrayList<String> result = new ArrayList<String>();
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        Map values = view.getAsParameterPathMap();
        for (Map.Entry e : values.entrySet()) {
            result.add(((ParameterPath)e.getKey()).getComponentName());
        }
        return result;
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChange(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        this.checkValidStates(true, true);
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.submitChange(componentName, parameterName, value);
        }
    }

    @Command(description="Submits changes of parameters to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChanges(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, Map<String, Object> changes) {
        this.checkValidStates(true, true);
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                this.configurationHandler.submitChange(componentName, entry.getKey(), entry.getValue());
            }
        }
    }

    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION)
    public void commitBulkChange() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true, true);
            try {
                ConfigurationView view = this.configurationHandler.commitBulkChange(null);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription cd = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(cd.getVersion(), cd.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
                conf_sub_log.info((Object)(this.currentConfigInfo.getLatestChanges().size() + " successfully set parameters"));
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION)
    public void dropAllSubmittedChanges() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.dropAllSubmittedChanges();
        }
    }

    @Command(description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public void dropSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.dropSubmittedChangesForComponent(name);
        }
    }

    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getSubmittedChangesForComponent(name);
            return map;
        }
    }

    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getAllSubmittedChanges();
            return map;
        }
    }

    @Command(description="returns the categories of this subsystem", type=Command.CommandType.QUERY)
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    List<String> getCategoriesList() {
        return new ArrayList<String>(this.getCategories());
    }

    @Command(description="returns the available configurations for the given category", type=Command.CommandType.CONFIGURATION)
    public Set<String> findAvailableConfigurationsForCategory(@Argument(allowedValueProvider="getCategoriesList") String category) {
        try {
            return this.configurationProxy.findAvailableConfigurationsForCategory(this.agentName, category);
        }
        catch (ConfigurationServiceException ex) {
            this.agent.getAlertService().raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
            throw ex;
        }
    }

    @Command(description="returns the current values for a given component that belong to the specified categories", type=Command.CommandType.CONFIGURATION)
    public Map<String, String> getCurrentValuesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, Set<String> categorySet) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getCurrentValuesForComponent(componentName, categorySet);
            return map;
        }
    }

    @Command(type=Command.CommandType.CONFIGURATION)
    public boolean isParameterConfigurable(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        return this.configurationHandler.isParameterConfigurable(componentName, parameterName);
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        return this.configurationHandler.isParameterReadOnly(componentName, parameterName);
    }

    @Command(description="locates configurations when they are loaded from the filesystem.", type=Command.CommandType.CONFIGURATION)
    public String locateConfigurations() {
        if (this.configurationProxy instanceof LocalConfigurationDAO) {
            return ((LocalConfigurationDAO)this.configurationProxy).locateConfigurations(this.currentConfigInfo);
        }
        return null;
    }

    public String getTag() {
        return this.descriptionName;
    }

    public void connected(AgentInfo ... ai) {
        for (AgentInfo a : ai) {
            if (!"true".equals(a.getAgentProperty("org.lsst.ccs.config.service"))) continue;
            this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.currentConfigInfo, this.stateService.getState()));
            return;
        }
    }

    public ConfigurationLock acquireConfigurationLock() {
        return new ConfigurationLock();
    }

    public ConfigurationLock tryAcquireConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationLock(time, unit);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Provided name cannot be null.");
        }
        ComponentConfigurationEnvironment environment = this.keyEnvironmentMap.get(name);
        if (environment == null) {
            throw new IllegalArgumentException("No Component with name \"" + name + "\" containing configuration parameters.");
        }
        return environment;
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci) {
        this.currentConfigInfo = ci;
        this.stateService.updateInternalState(new AgentState[]{this.currentConfigInfo.getConfigurationState()});
        this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.currentConfigInfo, this.stateService.getState()));
    }

    private ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView) {
        ConfigurationDescription configDesc = newView.getConfigurationDescription();
        if (configDesc == null) {
            configDesc = new ConfigurationDescription(this.categories);
        }
        ConfigurationDescription cd = new ConfigurationDescription(this.categories);
        for (String cat : this.currentConfigInfo.getCategorySet()) {
            if (configDesc.containsCategory(cat)) {
                cd.putTagForCategory(cat, (String)configDesc.getCategoryTags().get(cat), Integer.valueOf(-3));
                continue;
            }
            cd.putTagForCategory(cat, this.currentConfigInfo.getConfigNameForCategory(cat), this.currentConfigInfo.getConfigVersion(cat));
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(this.descriptionName);
        ConfigurationState nextState = ConfigurationState.CONFIGURED;
        for (Map.Entry entry : ConfigurationInfo.getParameterInfoGroupByCategory((List)this.currentConfigInfo.getAllParameterInfo()).entrySet()) {
            String category = (String)entry.getKey();
            boolean categoryCommitted = configDesc.containsCategory(category);
            boolean dirtyCat = false;
            for (ConfigurationParameterInfo cpi : (List)entry.getValue()) {
                boolean dirtyParm;
                ParameterPath path = ParameterPath.valueOf((String)cpi.getPathName());
                String currentValue = newView.getPathValue(path);
                String configuredValue = categoryCommitted ? currentValue : cpi.getConfiguredValue();
                ciBuilder.addParameter(ParameterPath.valueOf((String)cpi.getPathName()), cpi.getActualType(), cpi.getCategoryName(), cpi.getDescription(), cpi.getUnits(), cpi.isFinal(), cpi.isReadOnly());
                boolean bl = dirtyParm = !cpi.isReadOnly() && !currentValue.equals(configuredValue);
                if (!currentValue.equals(this.currentConfigInfo.getCurrentValueForParameter(path.toString())) || dirtyParm != cpi.isDirty()) {
                    ciBuilder.addRecentChange(path.toString());
                }
                ciBuilder.updateParameter(ParameterPath.valueOf((String)cpi.getPathName()), configuredValue, currentValue, dirtyParm);
                if (!dirtyParm) continue;
                dirtyCat = true;
                nextState = ConfigurationState.DIRTY;
            }
            ciBuilder.updateCategoryInformation(category, (String)cd.getCategoryTags().get(category), (Integer)cd.getCategoryVersions().get(category), dirtyCat);
        }
        if (cd.equals((Object)ConfigurationDescription.safeConfiguration(this.categories)) && nextState != ConfigurationState.DIRTY) {
            nextState = ConfigurationState.INITIAL_SAFE;
        }
        return ciBuilder.setConfigurationState(nextState).setGlobalConfigurationInformation(configDesc.getName(), Integer.valueOf(configDesc.getVersion())).setCCSTimeStamp(CCSTimeStamp.currentTime());
    }

    private ConfigurationView extractConfigurationViewFromCurrentConfigurationInfo() {
        List list = this.currentConfigInfo.getAllParameterInfo();
        ConfigurationView cv = new ConfigurationView();
        for (ConfigurationParameterInfo cpi : list) {
            cv.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getCurrentValue());
        }
        return cv;
    }

    private void checkValidStates(boolean failIfNotEM, boolean failIfInitialSafe) {
        ConfigurationState configState;
        if (this.configurationHandler == null) {
            throw new IllegalStateException("the configuration service is not initialized yet");
        }
        if (this.stateService.getState(PhaseState.class) == null) {
            throw new IllegalStateException("Configuration commands are accepted only when the subsystem is connected on the buses");
        }
        if (failIfInitialSafe && ((configState = (ConfigurationState)this.stateService.getState(ConfigurationState.class)) == null || configState == ConfigurationState.INITIAL_SAFE)) {
            throw new IllegalStateException("A full configuration load must be performed first, using loadConfiguration");
        }
        if (failIfNotEM && !this.agent.isInEngineeringMode()) {
            throw new IllegalStateException("Fine grained configuration actions are accepted only in engineering mode");
        }
    }

    private void handleException(RuntimeException ex) {
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        this.updateStateAndSendStatusConfigurationInfo(this.buildConfigurationInfo(view).build());
        if (ex instanceof ConfigurationServiceException) {
            this.agent.getAlertService().raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
        } else if (ex instanceof BulkSettingException) {
            this.agent.getAlertService().raiseAlert(CS_ALERT_2, AlertState.ALARM, ex.getMessage());
        }
        throw ex;
    }

    public class ConfigurationLock
    implements AutoCloseable {
        private ConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!ConfigurationService.this.configLock.tryLock(time, unit)) {
                throw new TimeoutException("could not acquire lock within given time");
            }
        }

        private ConfigurationLock() {
            ConfigurationService.this.configLock.lock();
        }

        @Override
        public void close() {
            ConfigurationService.this.configLock.unlock();
        }
    }
}

