package org.lsst.ccs.subsystem.cluster.monitor;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.framework.HasLifecycle;

/**
 * A Service to monitor the cluster activity.
 * 
 * @author The LSST CCS Team
 */
public class ClusterMonitorService extends Subsystem implements HasLifecycle {
    
    ClusterMonitorService() {
        super("clusterMonitor",AgentInfo.AgentType.SERVICE);
    }
    
    @Override
    public void build() {
        setAgentProperty("org.lsst.ccs.use.full.paths", "true");
        setAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY, AgentCategory.CLUSTER_MONITOR.name());
    }
}
