/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.ArrayList;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.utils.TrendingConnectionUtils;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.DataProviderDictionaryService;

public class ClusterMonitorService
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dataProviderDictionaryService;

    ClusterMonitorService() {
        super("clusterMonitor", AgentInfo.AgentType.SERVICE);
    }

    public void build() {
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.CLUSTER_MONITOR.name());
    }

    @Command(type=Command.CommandType.QUERY)
    public String checkDictionariesForTrending() {
        StringBuilder sb = new StringBuilder();
        TrendingConnectionUtils connUtils = null;
        for (AgentInfo ai : this.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
            if (!ai.getAgentProperty("agentCategory", "none").equals(AgentCategory.REST_SERVER.name())) continue;
            connUtils = new TrendingConnectionUtils(ai.getAgentProperty("rest-service-addr"), Integer.valueOf(ai.getAgentProperty("rest-service-port")).intValue());
        }
        if (connUtils == null) {
            sb.append("Could not find rest server\n");
            return sb.toString();
        }
        ArrayList<String> channels = new ArrayList<String>();
        DataChannel.DataChannelList channelList = connUtils.getChannelList();
        sb.append("Trending Channels: \n");
        for (DataChannel ch : channelList.list) {
            String channelPath = ch.getPathAsString();
            if (channelPath.startsWith("/")) {
                channelPath = channelPath.substring(1);
            }
            if (channels.contains(channelPath)) {
                sb.append("WARNING duplicate channel ").append(channelPath).append("\n");
            }
            channels.add(channelPath);
        }
        sb.append("\nChecking Trending data for worker subsystems\n");
        for (AgentInfo ai : this.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
            if (ai.getType() != AgentInfo.AgentType.WORKER) continue;
            DataProviderDictionary dataDict = this.dataProviderDictionaryService.getDataProviderDictionaryForAgent(ai.getName());
            if (dataDict == null) {
                sb.append("WARNING: no dictionary\n");
                continue;
            }
            sb.append("WORKER: ").append(ai.getName()).append("\n");
            int found = 0;
            int doNotTrend = 0;
            int missing = 0;
            for (DataProviderInfo dpi : dataDict.getDataProviderInfos()) {
                if (!dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE).equals(DataProviderInfo.Type.MONITORING.name()) && !dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE).equals(DataProviderInfo.Type.TRENDING.name())) continue;
                if (dpi.getAttributeValue(DataProviderInfo.Attribute.DO_NOT_TREND) != null) {
                    ++doNotTrend;
                    continue;
                }
                String trendingPath = ai.getName() + "/" + dpi.getFullPath();
                if (!channels.contains(trendingPath)) {
                    sb.append(trendingPath).append("\n");
                    ++missing;
                    continue;
                }
                ++found;
            }
            sb.append("Summary for ").append(ai.getName()).append(" found: ").append(found).append(" doNotTrend: ").append(doNotTrend).append(" missing: ").append(missing).append("\n");
        }
        return sb.toString();
    }
}

