package org.lsst.ccs.subsystem.cluster.monitor;

/**
 * A class to efficiently accumulate values.
 * 
 * @author The LSST CCS Team
 */
class Accumulate {
    
    private double accum = 0;
    private double min = Double.MAX_VALUE;
    private double max = -Double.MAX_VALUE;
    private int counter = 0;
    
    
    /**
     * Add to the existing value.
     */
    public synchronized void accumulate(double value) {
        accum += value;
        counter++;
        if ( value > max ) {
            max = value;
        }
        if ( value < min ) {
            min = value;
        }
    }
    
    public double getAverageValue() {
        return counter > 0 ? accum/((double)counter) : Double.NaN;
    }
    
    public double getMaxValue() {
        return counter > 0 ? max : Double.NaN;
    }
    
    public double getMinValue() {
        return counter > 0 ? min : Double.NaN;
    }

    public double getTotalValue() {
        return accum;
    }
    
    public int getCounts() {
        return counter;
    }
}
