package org.lsst.ccs.subsystem.cluster.monitor;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;

/**
 * A Service to monitor the cluster activity.
 * 
 * @author The LSST CCS Team
 */
public class ClusterMonitorService extends Subsystem implements HasLifecycle {
        

    @LookupField(strategy = LookupField.Strategy.TREE)
    AgentPropertiesService agentPropertiesService;
    
    ClusterMonitorService() {
        super("clusterMonitor",AgentInfo.AgentType.SERVICE);
    }
    
    @Override
    public void build() {
        agentPropertiesService.setAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY, AgentCategory.CLUSTER_MONITOR.name());
    }
    
}
