package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.cluster.monitor.data.DataType;

/**
 *
 * @author The LSST CCS Team
 */
public class BusTrafficDevice extends Device {

    private final List<String> channelDataList = new ArrayList<>();
    private Map dataMap;
    private final Object dataLock = new Object();
    @ConfigurationParameter(isFinal = true)
    private DataType type;

    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    private Map<String,Channel> channels = new HashMap<>();
    
    @Override
    protected void initDevice() {
        super.initDevice(); //To change body of generated methods, choose Tools | Templates.
        setOnline(true);
        
        for ( String path: channels.keySet()) {
            Channel c = channels.get(path);
            channelDataList.add(type.name().toLowerCase()+"/"+path);
        }
    }

    void setDataMap(Map dataMap) {
        synchronized(dataLock) {
            this.dataMap = dataMap;
        }
    }

    @Override
    protected double readChannel(Channel ch) {
        synchronized(dataLock) {
            if ( dataMap == null ) {
                return Double.NaN;
            }
            Object value = dataMap.get(type.name().toLowerCase()+"/"+ch.getName());
            if ( value == null ) {
                return Double.NaN;
            } else if ( value instanceof Integer ) {
                return ((Integer)value).doubleValue();
            }
            return (double)value;
        }
    }
    
    DataType getType() {
        return type;
    }
    
    @Override
    protected void close() {
    }

    @Override
    protected void initialize() {
    }
    
    
    Collection<String> getDataList() {
        return channelDataList;                  
    }
    
    
}
