import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.cluster.monitor.*;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.subsystem.cluster.monitor.BusTrafficMonitor.DataType;
import org.lsst.ccs.monitor.*;


taskConfig = ["monitor-update/taskPeriodMillis":60000,"monitor-publish/taskPeriodMillis":300000,"monitor-check/taskPeriodMillis":60000]

CCSBuilder builder = ["cluster-monitor"]

BusTrafficMonitor.restServerName = "lsst-mcm";
BusTrafficMonitor.restServerPort = 8080;

builder.
    clusterMonitor (ClusterMonitorService, nodeTags:taskConfig) {
    
    busTrafficMonitor (BusTrafficMonitor) {

        ClusterAlarm  (Alarm, description:"Cluster Monitor Alarm", eventParm:0)

        for (DataType type : DataType.values() ) {

            def deviceName = type.name().toLowerCase();
            "$deviceName" (BusTrafficDevice, type:type) {

                for (String subsystem : BusTrafficMonitor.getSubsystemsList()) {

                    for (Bus bus : Bus.values()) {

                    List<String> messages = BusTrafficMonitor.BUS_MAP.get(bus);

                        for (String message : messages) {
                            def String fullPath = "";
                            if (!subsystem.isEmpty()) {
                                fullPath += subsystem + "/";
                            }
                            fullPath += bus.name() + "/" + message;

                            def checkHi = BusTrafficMonitor.getCheckHi(type,fullPath)? "alarm" : "none";

                            "$fullPath" (Channel, units:BusTrafficMonitor.DATA_UNITS.get(type), limitLo:0, checkLo:"alarm", alarmLo:"ClusterAlarm",
                             checkHi:"alarm", limitHi:BusTrafficMonitor.getHighLimitFor(type,fullPath), dbandHi:BusTrafficMonitor.getDeadBandFor(type,fullPath), alarmHi:"ClusterAlarm");

 

                        }
                    }

                }




            }
            
        }



    }
    
//    "clusterViewMonitor" (JGroupsViewMonitor)

}