package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A class to efficiently count occurrences.
 * It internally contains a map with String keys. It is designed to increment
 * by one the occurrence of one given event identified by a given key.
 * 
 * @author The LSST CCS Team
 */
class Counter {
    
    private final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.cluster.monitor.counter");
    private final Map<String, int[]> counterMap = new HashMap<>();
    
    Counter(Collection<String> data) {
        for ( String d : data ) {
            counterMap.put(d, new int[]{0});
        }
    }
    
    /**
     * Increment the occurrence of the given key by one.
     * @param key The key to increment.
     */
    public synchronized void increment(String key) {
        if ( !counterMap.containsKey(key) ) {
            log.warn("Unknown key "+key);
            return;
        }
        counterMap.get(key)[0]++;
    }
    
    /**
     * Get the Map with the counters.
     * 
     * @return The Map with the counters.
     */
    public Map<String,Integer> getCountersMap() {
        Map<String,Integer> result = new HashMap();
        for ( String key: counterMap.keySet()) {
            result.put(key, counterMap.get(key)[0]);
        }
        return result;
    }
}
