/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataProviderInfo
implements Serializable {
    private static final long serialVersionUID = -905853368743117573L;
    private final String path;
    private final String key;
    private final Map<Attribute, String> attributes = new HashMap<Attribute, String>();

    public DataProviderInfo(String path, Type dataType, String key, Map<Attribute, String> attributes) {
        this.key = key;
        this.path = path;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        this.attributes.put(Attribute.DATA_TYPE, dataType.name());
    }

    public DataProviderInfo(String path, String key, Map<Attribute, String> attributes) {
        this.key = key;
        this.path = path;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public DataProviderInfo(String path, Type dataType, String name) {
        this(path, dataType, name, null);
    }

    public DataProviderInfo(String path, String name) {
        this(path, name, null);
    }

    public DataProviderInfo(String path, Type dataType) {
        this(path, Type.TRENDING, path, null);
    }

    public void addAttribute(Attribute attribute, String value) {
        if (value != null && !value.isEmpty()) {
            this.attributes.put(attribute, value);
        }
    }

    public String getAttributeValue(Attribute attr) {
        return this.attributes.get((Object)attr);
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public Attribute[] getAttributes() {
        return this.attributes.keySet().toArray(new Attribute[0]);
    }

    public static enum Attribute {
        DESCRIPTION("description", true),
        UNITS("units", true),
        TYPE("type", true),
        FORMAT("format", true),
        PAGE("page", false),
        ALARMHI("alarmhi", false),
        ALARMLO("alarmlo", false),
        STATE("state", true),
        RAFT_ID("raftId", true),
        REB_ID("rebId", true),
        AMPLIFIER_ID("amplifierId", true),
        ASPIC_ID("aspicId", true),
        SENSOR_ID("sensorId", true),
        DATA_GROUP("dataGroup", true),
        DATA_TYPE("dataType", false);

        private final String name;
        private final boolean isMetadata;

        private Attribute(String name, boolean isMetadata) {
            this.name = name;
            this.isMetadata = isMetadata;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMetadata() {
            return this.isMetadata;
        }
    }

    public static enum Type {
        TRENDING,
        MONITORING,
        CONFIGURATION,
        STATE;

    }
}

