/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.utilities.logging.Logger;

class Counter {
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.cluster.monitor.counter");
    private final Map<String, int[]> counterMap = new HashMap<String, int[]>();

    Counter(Collection<String> data) {
        for (String d : data) {
            this.counterMap.put(d, new int[]{0});
        }
    }

    public synchronized void increment(String key) {
        if (!this.counterMap.containsKey(key)) {
            this.log.warn((Object)("Unknown key " + key));
            return;
        }
        int[] nArray = this.counterMap.get(key);
        nArray[0] = nArray[0] + 1;
    }

    public Map<String, Integer> getCountersMap() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String key : this.counterMap.keySet()) {
            result.put(key, this.counterMap.get(key)[0]);
        }
        return result;
    }
}

