/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.cluster.monitor.Counter;
import org.lsst.ccs.utilities.logging.Logger;

class Accumulate {
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.cluster.monitor.accumulate");
    private final Map<String, double[]> accumulateMap = new HashMap<String, double[]>();
    private final Counter counter;

    Accumulate(Collection<String> data) {
        this.counter = new Counter(data);
        for (String d : data) {
            this.accumulateMap.put(d, new double[]{0.0});
        }
    }

    public synchronized void accumulate(double value, String key) {
        if (!this.accumulateMap.containsKey(key)) {
            this.log.warn((Object)("Unknown key " + key));
            return;
        }
        double[] dArray = this.accumulateMap.get(key);
        dArray[0] = dArray[0] + value;
        this.counter.increment(key);
    }

    public Map<String, Double> getAverageMap() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (String key : this.accumulateMap.keySet()) {
            result.put(key, this.accumulateMap.get(key)[0] / (double)this.counter.getCountersMap().get(key).intValue());
        }
        return result;
    }
}

