package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A class to efficiently accumulate values.
 * It internally contains a map with String keys. It is designed to increment
 * by a given value the entity identified by a given key.
 * 
 * @author The LSST CCS Team
 */
class Accumulate {
    
    private final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.cluster.monitor.accumulate");
    private final Map<String, double[]> accumulateMap = new HashMap<>();
    private final Counter counter;
    
    Accumulate(Collection<String> data) {
        counter = new Counter(data);
        for ( String d : data ) {
            accumulateMap.put(d, new double[]{0});
        }
    }
    
    
    /**
     * Add to the existing value of the given key by one.
     * @param key The key to increment.
     */
    public synchronized void accumulate(double value, String key) {
        if ( !accumulateMap.containsKey(key) ) {
            log.warn("Unknown key "+key);
            return;
        }
        accumulateMap.get(key)[0]+=value;
        counter.increment(key);
    }
    
    /**
     * Get the Map with the counters.
     * 
     * @return The Map with the counters.
     */
    public Map<String,Double> getAverageMap() {
        Map<String,Double> result = new HashMap();
        for ( String key: accumulateMap.keySet()) {
            result.put(key, accumulateMap.get(key)[0]/counter.getCountersMap().get(key));
        }
        return result;
    }
}
