/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusRuntimeInfo;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.utils.ClientRequestUtils;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.cluster.monitor.Accumulate;
import org.lsst.ccs.subsystem.cluster.monitor.BusTrafficDevice;
import org.lsst.ccs.subsystem.cluster.monitor.Counter;

public class BusTrafficMonitor
implements HasLifecycle {
    private static final Object counterLock = new Object();
    private static Counter counter;
    private static Accumulate sizeAccumulator;
    private static Accumulate timeAccumulator;
    private static ClientRequestUtils restUtils;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    public static String restServerName;
    public static int restServerPort;
    private static final List<String> recentSubsystems;
    private static final List<String> STATUS_MESSAGES;
    private static final List<String> COMMAND_MESSAGES;
    private static final List<String> LOG_MESSAGES;
    private static Map<Bus, List<String>> BUS_MAP;
    private static Map<DataType, String> DATA_UNITS;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<BusTrafficDevice> devices = new ArrayList<BusTrafficDevice>();

    public static double getHighLimitFor(DataType type, String dataName) {
        switch (type) {
            case TRAFFIC: {
                if (dataName.contains("/all")) {
                    return recentSubsystems.size() * 700;
                }
                return 700.0;
            }
            case TIME: {
                for (Bus b : Bus.values()) {
                    if (!dataName.endsWith(b.name().toLowerCase() + "/all")) continue;
                    return 4.0;
                }
                return 70.0;
            }
            case SIZE: {
                for (Bus b : Bus.values()) {
                    if (!dataName.endsWith(b.name().toLowerCase() + "/all")) continue;
                    return 4.0;
                }
                break;
            }
        }
        return 0.0;
    }

    public static double getDeadBandFor(DataType type, String dataName) {
        switch (type) {
            case TRAFFIC: {
                if (dataName.contains("/all")) {
                    return recentSubsystems.size() * 100;
                }
                return 200.0;
            }
            case TIME: {
                return 20.0;
            }
            case SIZE: {
                return 100.0;
            }
        }
        return 0.0;
    }

    public static boolean getCheckHi(DataType type, String dataName) {
        switch (type) {
            case TRAFFIC: {
                return true;
            }
            case TIME: {
                for (Bus b : Bus.values()) {
                    if (!dataName.endsWith(b.name().toLowerCase() + "/all")) continue;
                    return true;
                }
                return false;
            }
            case SIZE: {
                for (Bus b : Bus.values()) {
                    if (!dataName.endsWith(b.name().toLowerCase() + "/all")) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static List<String> getSubsystemsList() {
        if (recentSubsystems.isEmpty()) {
            restUtils = new ClientRequestUtils(restServerName, restServerPort);
            recentSubsystems.add("");
            if (restServerName.isEmpty()) {
                recentSubsystems.add("demo");
                recentSubsystems.add("demo1");
                recentSubsystems.add("client");
                recentSubsystems.add("other");
            } else {
                DataChannel.DataChannelList list = restUtils.getChannelList();
                for (DataChannel dc : list.list) {
                    String subsystemName = dc.getPath()[0];
                    if (recentSubsystems.contains(subsystemName)) continue;
                    recentSubsystems.add(subsystemName);
                }
                recentSubsystems.add("client");
                recentSubsystems.add("other");
            }
        }
        return recentSubsystems;
    }

    public void build() {
        this.agent.setAgentProperty("org.lsst.ccs.use.full.paths", "true");
        AgentPeriodicTask resetCounterAndPublish = new AgentPeriodicTask("busTrafficStatsUpdate", () -> this.resetCounterAndPublish()).withPeriod(Duration.ofSeconds(60L));
        this.agent.getAgentPeriodicTaskService().scheduleAgentPeriodicTask(resetCounterAndPublish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounters() {
        Object object = counterLock;
        synchronized (object) {
            for (BusTrafficDevice d : this.devices) {
                switch (d.getType()) {
                    case TRAFFIC: {
                        counter = new Counter(d.getDataList());
                        break;
                    }
                    case TIME: {
                        timeAccumulator = new Accumulate(d.getDataList());
                        break;
                    }
                    case SIZE: {
                        sizeAccumulator = new Accumulate(d.getDataList());
                    }
                }
            }
        }
    }

    public void start() {
        this.resetCounters();
        this.agent.getMessagingAccess().addCommandMessageListener((CommandMessageListener)new CommandBusCounterListener());
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)new StatusBusCounterListener());
        this.agent.getMessagingAccess().addLogMessageListener((LogMessageListener)new LogBusCounterListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounterAndPublish() {
        Accumulate oldTimeAccumulator;
        Accumulate oldSizeAccumulator;
        Counter oldCounter;
        Iterator<BusTrafficDevice> iterator = counterLock;
        synchronized (iterator) {
            oldCounter = counter;
            oldSizeAccumulator = sizeAccumulator;
            oldTimeAccumulator = timeAccumulator;
            this.resetCounters();
        }
        for (BusTrafficDevice device : this.devices) {
            Map<String, Integer> dataMap = device.getType() == DataType.TRAFFIC ? oldCounter.getCountersMap() : (device.getType() == DataType.SIZE ? oldSizeAccumulator.getAverageMap() : oldTimeAccumulator.getAverageMap());
            device.setDataMap(dataMap);
        }
    }

    public static double sizeOf(Serializable object) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException ieo) {
            return 0.0;
        }
        return byteOutputStream.toByteArray().length / 1000;
    }

    static {
        restServerName = "";
        restServerPort = 8080;
        recentSubsystems = new ArrayList<String>();
        STATUS_MESSAGES = new ArrayList<String>();
        COMMAND_MESSAGES = new ArrayList<String>();
        LOG_MESSAGES = new ArrayList<String>();
        BUS_MAP = new HashMap<Bus, List<String>>();
        DATA_UNITS = new HashMap<DataType, String>();
        STATUS_MESSAGES.add(StatusHeartBeat.class.getSimpleName());
        STATUS_MESSAGES.add(StatusStateChangeNotification.class.getSimpleName());
        STATUS_MESSAGES.add(StatusRuntimeInfo.class.getSimpleName());
        STATUS_MESSAGES.add(StatusDataProviderDictionary.class.getSimpleName());
        STATUS_MESSAGES.add(StatusRaisedAlert.class.getSimpleName());
        STATUS_MESSAGES.add(StatusClearedAlert.class.getSimpleName());
        STATUS_MESSAGES.add(StatusSubsystemData.class.getSimpleName());
        STATUS_MESSAGES.add(StatusRaisedAlertSummary.class.getSimpleName());
        STATUS_MESSAGES.add(StatusConfigurationInfo.class.getSimpleName());
        STATUS_MESSAGES.add("all");
        STATUS_MESSAGES.add("other");
        COMMAND_MESSAGES.add(CommandResult.class.getSimpleName());
        COMMAND_MESSAGES.add(CommandRequest.class.getSimpleName());
        COMMAND_MESSAGES.add(CommandNack.class.getSimpleName());
        COMMAND_MESSAGES.add(CommandAck.class.getSimpleName());
        COMMAND_MESSAGES.add("all");
        LOG_MESSAGES.add("all");
        BUS_MAP.put(Bus.STATUS, STATUS_MESSAGES);
        BUS_MAP.put(Bus.COMMAND, COMMAND_MESSAGES);
        BUS_MAP.put(Bus.LOG, LOG_MESSAGES);
        DATA_UNITS.put(DataType.TRAFFIC, "#/min");
        DATA_UNITS.put(DataType.SIZE, "Kb");
        DATA_UNITS.put(DataType.TIME, "ms");
    }

    private static class StatusBusCounterListener
    implements StatusMessageListener {
        String busName = Bus.STATUS.name();

        private StatusBusCounterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            String busKey;
            long deltaT = System.currentTimeMillis() - msg.getTimeStamp();
            String string = busKey = msg.getOriginAgentInfo().getType().ordinal() >= AgentInfo.AgentType.WORKER.ordinal() ? msg.getOriginAgentInfo().getName() : "client";
            if (!BusTrafficMonitor.getSubsystemsList().contains(busKey)) {
                busKey = "other";
            }
            busKey = busKey + "/" + this.busName;
            String classKey = msg.getClass().getSimpleName();
            if (!((List)BUS_MAP.get(Bus.STATUS)).contains(classKey)) {
                classKey = "other";
            }
            String messageKey = busKey + "/" + classKey;
            String busMessageTypeKey = this.busName + "/" + classKey;
            double size = BusTrafficMonitor.sizeOf((Serializable)msg);
            Object object = counterLock;
            synchronized (object) {
                counter.increment("traffic/" + this.busName + "/all");
                counter.increment("traffic/" + busKey + "/all");
                counter.increment("traffic/" + busMessageTypeKey);
                counter.increment("traffic/" + messageKey);
                sizeAccumulator.accumulate(size, "size/" + this.busName + "/all");
                sizeAccumulator.accumulate(size, "size/" + busMessageTypeKey);
                sizeAccumulator.accumulate(size, "size/" + busKey + "/all");
                sizeAccumulator.accumulate(size, "size/" + messageKey);
                timeAccumulator.accumulate(deltaT, "time/" + this.busName + "/all");
                timeAccumulator.accumulate(deltaT, "time/" + busMessageTypeKey);
                timeAccumulator.accumulate(deltaT, "time/" + busKey + "/all");
                timeAccumulator.accumulate(deltaT, "time/" + messageKey);
            }
        }
    }

    private static class LogBusCounterListener
    implements LogMessageListener {
        String busName = Bus.LOG.name();

        private LogBusCounterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLogMessage(LogMessage msg) {
            String busKey;
            long deltaT = System.currentTimeMillis() - msg.getTimeStamp();
            String string = busKey = msg.getOriginAgentInfo().getType().ordinal() >= AgentInfo.AgentType.WORKER.ordinal() ? msg.getOriginAgentInfo().getName() : "client";
            if (!BusTrafficMonitor.getSubsystemsList().contains(busKey)) {
                busKey = "other";
            }
            busKey = busKey + "/" + this.busName;
            double size = BusTrafficMonitor.sizeOf((Serializable)msg);
            Object object = counterLock;
            synchronized (object) {
                counter.increment("traffic/" + this.busName + "/all");
                counter.increment("traffic/" + busKey + "/all");
                sizeAccumulator.accumulate(size, "size/" + this.busName + "/all");
                sizeAccumulator.accumulate(size, "size/" + busKey + "/all");
                timeAccumulator.accumulate(deltaT, "time/" + this.busName + "/all");
                timeAccumulator.accumulate(deltaT, "time/" + busKey + "/all");
            }
        }
    }

    private static class CommandBusCounterListener
    implements CommandMessageListener {
        String busName = Bus.COMMAND.name();

        private CommandBusCounterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCommandMessage(CommandMessage msg) {
            String busKey;
            long deltaT = System.currentTimeMillis() - msg.getTimeStamp();
            String string = busKey = msg.getOriginAgentInfo().getType().ordinal() >= AgentInfo.AgentType.WORKER.ordinal() ? msg.getOriginAgentInfo().getName() : "client";
            if (!BusTrafficMonitor.getSubsystemsList().contains(busKey)) {
                busKey = "other";
            }
            busKey = busKey + "/" + this.busName;
            String busMessageTypeKey = this.busName + "/" + msg.getClass().getSimpleName();
            String messageKey = busKey + "/" + msg.getClass().getSimpleName();
            double size = BusTrafficMonitor.sizeOf((Serializable)msg);
            Object object = counterLock;
            synchronized (object) {
                counter.increment("traffic/" + this.busName + "/all");
                counter.increment("traffic/" + busMessageTypeKey);
                counter.increment("traffic/" + busKey + "/all");
                counter.increment("traffic/" + messageKey);
                sizeAccumulator.accumulate(size, "size/" + this.busName + "/all");
                sizeAccumulator.accumulate(size, "size/" + busMessageTypeKey);
                sizeAccumulator.accumulate(size, "size/" + busKey + "/all");
                sizeAccumulator.accumulate(size, "size/" + messageKey);
                timeAccumulator.accumulate(deltaT, "time/" + this.busName + "/all");
                timeAccumulator.accumulate(deltaT, "time/" + busMessageTypeKey);
                timeAccumulator.accumulate(deltaT, "time/" + busKey + "/all");
                timeAccumulator.accumulate(deltaT, "time/" + messageKey);
            }
        }
    }

    public static enum DataType {
        TRAFFIC,
        SIZE,
        TIME;

    }
}

