package org.lsst.ccs.subsystem.ccob.thin;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import static org.lsst.ccs.commons.annotations.LookupField.Strategy.TREE;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;

/**
 * Provides tools used by other components of the subsystem.
 * @author tether
 */
public class Util implements HasLifecycle {
    
    @LookupField(strategy=TREE)
    private volatile Subsystem subsys;
    
     /**
     * Sets the Agent property marking this as a motorplatform subsystem.
     * Must be done before we connect to the buses.
     */
    @Override
    public void postInit() {
        subsys
            .getAgentService(AgentPropertiesService.class)
            .setAgentProperty(
                MotorplatformType.MOTORPLATFORM_TYPE_AGENT_PROPERTY,
                "CCOBTHIN");
    }
   

}
