/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.thin;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.ccob.thin.buses.TBServerException;

public class Alerts {
    public static Alert SERVER_ERROR = new Alert("SERVER_ERROR", "TB_Server replied with an error or a warning.");
    public static Alert COMM_ERROR = new Alert("COMM_ERROR", "There is a problem communicating with TB_Server.");
    public static Alert INTERNAL_ERROR = new Alert("INTERNAL_ERROR", "An exception was raised indicating a problem with the subsystem.");

    private Alerts() {
    }

    public static void registerAllAlerts(AlertService al) {
        al.registerAlert(SERVER_ERROR, AlertService.ALWAYS);
        al.registerAlert(COMM_ERROR, AlertService.ALWAYS);
        al.registerAlert(INTERNAL_ERROR, AlertService.ALWAYS);
    }

    public static void raiseServerAlert(AlertService al, TBServerException exc) {
        al.raiseAlert(SERVER_ERROR, AlertState.ALARM, exc.getMessage(), AlertService.RaiseAlertStrategy.ALWAYS);
    }

    public static void raiseCommAlert(AlertService al, DriverException exc) {
        Throwable cause = exc.getCause() != null ? exc.getCause() : exc;
        al.raiseAlert(COMM_ERROR, AlertState.WARNING, exc.getMessage(), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
    }

    public static void raiseInternalAlert(AlertService al, Throwable exc) {
        al.raiseAlert(INTERNAL_ERROR, AlertState.ALARM, exc.getMessage(), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
    }
}

