/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.thin;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.ccob.thin.AsciiAuto;
import org.lsst.ccs.subsystem.ccob.thin.MockThin;
import org.lsst.ccs.subsystem.ccob.thin.TBServerException;
import org.lsst.ccs.subsystem.ccob.thin.ValueParser;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;

public class Controller
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(Controller.class.getName());
    private final ScheduledExecutorService scheduler;
    private final BlockingQueue<CannedCommand> execQueue;
    private final AtomicReference<String> lastReply;
    private ControllerStatus ctrlStatus;
    private Map<String, AxisStatus> axisStati;
    @LookupField(strategy=LookupField.Strategy.TOP)
    volatile Subsystem subsys;
    @ConfigurationParameter(description="The interval between automatic status updates and publishing.", units="s")
    private volatile Duration statusUpdateInterval = Duration.ofSeconds(30L);
    @ConfigurationParameter(description="How long to wait for the TB server to respond to a command.", units="s")
    private volatile Duration responseTimeout = Duration.ofSeconds(120L);
    @ConfigurationParameter(description="The IPv4 address (or hostname) of the TB server.")
    private volatile String tbIpv4Address = "127.0.0.1";
    @ConfigurationParameter(description="The TCP port on which the TB server is listening.")
    private volatile int tbTcpPort = 1557;
    @ConfigurationParameter(description="The frequency of the power main to which the CCOB is connected. 50 or 60.", units="Hz")
    private volatile double powerHz = 60.0;
    private static final PlatformConfig config;
    private static final String ERROR_PREFIX = "ERROR:";
    private static final String WARNING_PREFIX = "Warning:";

    public Controller() {
        this.scheduler = Executors.newScheduledThreadPool(2);
        this.execQueue = new SynchronousQueue<CannedCommand>();
        this.lastReply = new AtomicReference<String>("");
        this.ctrlStatus = new ControllerStatus("UP", true, "OK");
        this.axisStati = config.getAxisNames().stream().map(axname -> new AxisStatus(axname, true, false, false, false, false, Collections.emptyList(), 0.0)).collect(Collectors.toMap(stat -> stat.getAxisName(), stat -> stat));
    }

    public void init() {
        DataProviderDictionaryService dictService = (DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class);
        dictService.registerData(new KeyValueData(this.kvdKey((Serializable)this.ctrlStatus), (Serializable)this.ctrlStatus));
        for (AxisStatus status : this.axisStati.values()) {
            KeyValueData kvd = new KeyValueData(this.kvdKey(status), (Serializable)status);
            dictService.registerData(kvd);
        }
    }

    public void start() {
        this.scheduler.submit(this::commandLoop);
        this.submit(() -> {
            try (AsciiAuto driver = this.getOpenDriver();){
                String string = this.sendCommandAndCheck(driver, "COLOR OFF");
                return string;
            }
        });
        this.scheduler.scheduleWithFixedDelay(() -> this.submitUpdateStatus(), 0L, this.statusUpdateInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void postShutdown() {
        this.scheduler.shutdownNow();
    }

    public void moveAxisRelative(MoveAxisRelative cmd) {
        this.submit(() -> this.doMoveAxisRelative(cmd));
    }

    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        this.submit(() -> this.doMoveAxisAbsolute(cmd));
    }

    public void sendAxisStatus(SendAxisStatus cmd) {
        this.submit(() -> this.doSendAxisStatus(cmd));
    }

    public void sendConfiguration(SendConfiguration cmd) {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("PlatformConfig", (Serializable)config));
        this.submit(() -> this.doRegularStatusUpdate());
    }

    public void sendControllerStatus(SendControllerStatus cmd) {
        this.submit(() -> this.doSendControllerStatus(cmd));
    }

    public void stopAllMotion(StopAllMotion cmd) {
        this.submit(() -> this.doStopAllMotion(cmd));
    }

    public String status(String axisName) {
        CompletableFuture result = new CompletableFuture();
        this.submit(() -> this.completeFuture(result, this.doStatus(axisName)));
        return (String)this.getFuture(result);
    }

    public void switchDiode(String newState) {
        this.submit(() -> this.doSwitchDiode(newState));
    }

    public double picoReadCurrent() {
        CompletableFuture result = new CompletableFuture();
        this.submit(() -> this.doPicoReadCurrent(result));
        return (Double)this.getFuture(result);
    }

    public void picoSetTime(double millis) {
        this.submit(() -> this.doPicoSetTime(millis));
    }

    public void picoSetRange(int range) {
        this.submit(() -> this.doPicoSetRange(range));
    }

    public double picoGetRange() {
        CompletableFuture result = new CompletableFuture();
        this.submit(() -> this.doPicoGetRange(result));
        return (Double)this.getFuture(result);
    }

    public void hyperSetWavelength(String wavelength) {
        this.submit(() -> this.doHyperSetWavelength(wavelength));
    }

    public void hyperSwitchFastShutter(String newState) {
        this.submit(() -> this.doHyperSwitchFastShutter(newState));
    }

    public void hyperStartFastExposure(int millis) {
        this.submit(() -> this.doHyperStartFastExposure(millis));
    }

    public void hyperSwitchMainShutter(String newState) {
        this.submit(() -> this.doHyperSwitchMainShutter(newState));
    }

    public void hyperSwitchLamp(String newState) {
        this.submit(() -> this.doHyperSwitchLamp(newState));
    }

    public void hyperZOP(String gratingName) {
        this.submit(() -> this.doHyperZOP(gratingName));
    }

    public double getDiodeAttenuation() {
        CompletableFuture result = new CompletableFuture();
        this.submit(() -> this.doGetDiodeAttenuation(result));
        return (Double)this.getFuture(result);
    }

    public double readThenIlluminate(int millis) {
        CompletableFuture result = new CompletableFuture();
        this.submit(() -> this.doReadThenIlluminate(result, millis));
        return (Double)this.getFuture(result);
    }

    public double illuminateThenRead(int millis) {
        CompletableFuture result = new CompletableFuture();
        this.submit(() -> this.doIlluminateThenRead(result, millis));
        return (Double)this.getFuture(result);
    }

    public String getTarget() {
        CompletableFuture result = new CompletableFuture();
        this.submit(() -> this.doGetTarget(result));
        return (String)this.getFuture(result);
    }

    void setTargetTo(double x, double y) {
        this.submit(() -> this.doSetTargetTo(x, y));
    }

    void setTargetHere() {
        this.submit(this::doSetTargetHere);
    }

    void aimAgainXY() {
        this.submit(this::doAimAgainXY);
    }

    void aimAgainUB() {
        this.submit(this::doAimAgainUB);
    }

    public String getLastReply() {
        return this.lastReply.get();
    }

    private void commandLoop() {
        LOG.info("Starting the command execution task.");
        while (!Thread.currentThread().isInterrupted()) {
            CannedCommand canned;
            try {
                canned = this.execQueue.take();
            }
            catch (InterruptedException exc) {
                break;
            }
            try {
                String result = canned.command.call();
                this.setCommandStatus("OK");
                canned.reply.complete(result);
            }
            catch (InterruptedException exc) {
                canned.reply.completeExceptionally(exc);
                break;
            }
            catch (DriverException exc) {
                LOG.log(Level.SEVERE, null, exc);
                this.setConnectionStatus("DOWN");
                this.setCommandStatus("ERROR");
                canned.reply.completeExceptionally(exc);
            }
            catch (Exception exc) {
                LOG.log(Level.SEVERE, null, exc);
                this.setCommandStatus("ERROR");
                canned.reply.completeExceptionally(exc);
            }
        }
        LOG.info("Normal termination of the command execution task.");
    }

    private void submit(Callable<String> code) {
        CannedCommand canned = new CannedCommand(new CompletableFuture<String>(), code);
        try {
            this.execQueue.put(canned);
        }
        catch (InterruptedException ex) {
            LOG.warning("Command queueing was interrupted.");
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.lastReply.set(canned.reply.get());
        }
        catch (InterruptedException exc) {
            LOG.warning("Waiting for command completion was interrupted.");
            Thread.currentThread().interrupt();
            this.lastReply.set("ERROR: Subsystem was interrupted.");
        }
        catch (ExecutionException exc) {
            Throwable cause = exc.getCause();
            if (cause.getMessage().startsWith("ERROR")) {
                this.lastReply.set(cause.getMessage());
            } else {
                this.lastReply.set("ERROR: " + cause.getMessage());
            }
            throw new RuntimeException(cause);
        }
    }

    /*
     * Loose catch block
     */
    private String doMoveAxisRelative(MoveAxisRelative cmd) throws DriverException {
        String axis = this.checkAxisName(cmd.getAxisName());
        if (axis.equals("P")) {
            throw new IllegalArgumentException("The P axis doesn't implement relative motion commands.");
        }
        try {
            try (AsciiAuto driver = this.getOpenDriver();){
                String motionReply;
                double dt = 0.1;
                double D = cmd.getDistance();
                double T = 0.001 * (double)cmd.getTime().toMillis();
                double a = Math.abs(D) / (0.1 * T - 0.010000000000000002);
                double v = a * 0.1;
                String tbAxis = "XY".contains(axis) ? "XY" : axis;
                this.sendCommandAndCheck(driver, String.format("%s V=%.1f", tbAxis, v));
                this.sendCommandAndCheck(driver, String.format("%s ACC=%.1f", tbAxis, a));
                this.publishMotionStatus(axis, true);
                String string = motionReply = this.sendCommandAndCheck(driver, String.format("%s+=%.1f", axis, cmd.getDistance()));
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.publishMotionStatus(axis, false);
        }
    }

    /*
     * Loose catch block
     */
    private String doMoveAxisAbsolute(MoveAxisAbsolute cmd) throws DriverException {
        String axis = this.checkAxisName(cmd.getAxisName());
        try {
            try (AsciiAuto driver = this.getOpenDriver();){
                String motionReply;
                if (!axis.equals("P")) {
                    double dt = 0.1;
                    double v = cmd.getSpeed();
                    double a = v / 0.1;
                    String tbAxis = "XY".contains(axis) ? "XY" : axis;
                    this.sendCommandAndCheck(driver, String.format("%s V=%.1f", tbAxis, v));
                    this.sendCommandAndCheck(driver, String.format("%s ACC=%.1f", tbAxis, a));
                } else {
                    LOG.warning("For most work use diodeOn() and diodeOff() rather than explicit P-axis motion.");
                }
                this.publishMotionStatus(axis, true);
                String string = motionReply = this.sendCommandAndCheck(driver, String.format("%s=%.1f", axis, cmd.getPosition()));
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.publishMotionStatus(axis, false);
        }
    }

    private String doSendAxisStatus(SendAxisStatus cmd) throws DriverException {
        return "OK";
    }

    private String doSendControllerStatus(SendControllerStatus cmd) {
        return "OK";
    }

    private String doStopAllMotion(StopAllMotion cmd) throws DriverException {
        throw new RuntimeException("There is no way to use the TB server to stop a motion in progress.");
    }

    private String doRegularStatusUpdate() throws DriverException {
        String reply = ERROR_PREFIX;
        for (String axisName : config.getAxisNames()) {
            try {
                AsciiAuto driver = this.getOpenDriver();
                Throwable throwable = null;
                try {
                    reply = this.sendCommandAndCheck(driver, axisName + "?");
                    Map<String, Double> values = ValueParser.parse(reply);
                    AxisStatus newStatus = new AxisStatus(axisName, true, false, false, false, false, Collections.emptyList(), Objects.requireNonNull(values.get(axisName), "Can't find info for axis " + axisName).doubleValue());
                    this.axisStati.put(axisName, newStatus);
                    this.publish(newStatus);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (driver == null) continue;
                    if (throwable != null) {
                        try {
                            driver.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    driver.close();
                }
            }
            catch (ValueParser.ParseError exc) {
                LOG.log(Level.WARNING, "Could not parse reply to {0}?\n{1}", new Object[]{axisName, exc.getMessage()});
            }
            catch (Throwable exc) {
                LOG.log(Level.SEVERE, "Error during status query.", exc);
            }
        }
        return reply;
    }

    private String doStatus(String controllerName) throws DriverException {
        controllerName = controllerName.toUpperCase();
        Throwable throwable = null;
        try (AsciiAuto driver = this.getOpenDriver();){
            if (" XY UB P H K ".contains(controllerName)) {
                String string = this.sendCommandAndCheck(driver, controllerName + " STATUS");
                return string;
            }
            if (controllerName.startsWith("SUMM")) {
                String string = this.sendCommandAndCheck(driver, "STATUS");
                return string;
            }
            try {
                throw new IllegalArgumentException("Valid controller names are XY, UB, P, H, K or SUMMARY.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String doSwitchDiode(String newState) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "P DIODE " + newState);
            return string;
        }
    }

    private String doPicoReadCurrent(CompletableFuture<Double> result) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String reply = this.sendCommandAndCheck(driver, "K?");
            this.completeFuture(result, ValueParser.parse(reply).get("K"));
            String string = reply;
            return string;
        }
    }

    private String doPicoSetTime(double millis) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String cmd = String.format("K PLC=%.2f", 0.001 * millis * this.powerHz);
            String string = this.sendCommandAndCheck(driver, cmd);
            return string;
        }
    }

    private String doPicoSetRange(int range) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String cmd = String.format("K RANGE=%d", range);
            String string = this.sendCommandAndCheck(driver, cmd);
            return string;
        }
    }

    private String doPicoGetRange(CompletableFuture<Double> result) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String reply = this.sendCommandAndCheck(driver, "K RANGE?");
            reply = reply.substring(0, reply.indexOf(40));
            this.completeFuture(result, ValueParser.parse(reply).get("Range"));
            String string = reply;
            return string;
        }
    }

    private String doHyperSetWavelength(String wavelength) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "H=" + wavelength.toUpperCase());
            return string;
        }
    }

    private String doHyperSwitchFastShutter(String newState) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "H HSS " + newState);
            return string;
        }
    }

    private String doHyperStartFastExposure(int millis) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "H HSS=" + millis);
            return string;
        }
    }

    private String doHyperSwitchMainShutter(String newState) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "H SHUTTER " + newState);
            return string;
        }
    }

    private String doHyperSwitchLamp(String newState) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "H LAMP " + newState);
            return string;
        }
    }

    private String doHyperZOP(String gratingName) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "H=ZOP" + gratingName.toUpperCase());
            return string;
        }
    }

    private String doGetDiodeAttenuation(CompletableFuture<Double> result) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String reply = this.sendCommandAndCheck(driver, "KC?");
            this.completeFuture(result, ValueParser.parse("KC=" + reply + "u").get("KC"));
            String string = reply;
            return string;
        }
    }

    private String doReadThenIlluminate(CompletableFuture<Double> result, int millis) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String reply = this.sendCommandAndCheck(driver, "KH HSS=" + millis);
            this.completeFuture(result, ValueParser.parse(reply).get("K"));
            String string = reply;
            return string;
        }
    }

    private String doIlluminateThenRead(CompletableFuture<Double> result, int millis) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String reply = this.sendCommandAndCheck(driver, String.format("HK PLC=%.1f", 0.001 * (double)millis * this.powerHz));
            this.completeFuture(result, ValueParser.parse(reply).get("K"));
            String string = reply;
            return string;
        }
    }

    private String doGetTarget(CompletableFuture<String> result) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String reply = this.sendCommandAndCheck(driver, "TARGET?");
            this.completeFuture(result, reply);
            String string = reply;
            return string;
        }
    }

    private String doSetTargetTo(double x, double y) throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, String.format("TARGET=%.1f,%.1f", x, y));
            return string;
        }
    }

    private String doSetTargetHere() throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "TARGET");
            return string;
        }
    }

    private String doAimAgainXY() throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "AAXY");
            return string;
        }
    }

    private String doAimAgainUB() throws DriverException {
        try (AsciiAuto driver = this.getOpenDriver();){
            String string = this.sendCommandAndCheck(driver, "AAUB");
            return string;
        }
    }

    private void submitUpdateStatus() {
        this.submit(() -> this.doRegularStatusUpdate());
    }

    private AsciiAuto getOpenDriver() throws DriverException {
        this.setConnectionStatus("UP");
        this.setCommandStatus("RUNNING");
        if (RunMode.isSimulation()) {
            return new MockThin();
        }
        AsciiAuto driver = new AsciiAuto();
        driver.setResponseTerm(Ascii.Terminator.LF);
        driver.setTimeout(0.001 * (double)this.responseTimeout.toMillis());
        driver.openNet(this.tbIpv4Address, this.tbTcpPort);
        return driver;
    }

    private String checkAxisName(String in) throws IllegalArgumentException {
        String out = in.toUpperCase();
        if (!config.getAxisNames().contains(out)) {
            throw new IllegalArgumentException("Bad axis name " + out);
        }
        return out;
    }

    private String sendCommandAndCheck(Ascii driver, String tbserverCommand) throws DriverException {
        driver.write(tbserverCommand);
        String reply = this.collectReply(driver);
        if (reply.startsWith(ERROR_PREFIX) || reply.startsWith(WARNING_PREFIX)) {
            throw new TBServerException(reply);
        }
        return reply;
    }

    private String collectReply(Ascii driver) throws DriverException {
        String s;
        LinkedList<String> lines = new LinkedList<String>();
        do {
            s = driver.read();
            lines.add(s);
        } while (!s.isEmpty());
        return String.join((CharSequence)"\n", lines).trim();
    }

    private void setConnectionStatus(String stat) {
        this.ctrlStatus = new ControllerStatus(stat, this.ctrlStatus.isMotionEnabled(), this.ctrlStatus.getLastCommandStatus());
        this.publish((Serializable)this.ctrlStatus);
    }

    private void setCommandStatus(String stat) {
        this.ctrlStatus = new ControllerStatus(this.ctrlStatus.getCommLinkStatus(), this.ctrlStatus.isMotionEnabled(), stat);
        this.publish((Serializable)this.ctrlStatus);
    }

    private String kvdKey(Serializable value) {
        return value.getClass().getSimpleName();
    }

    private void publish(Serializable value) {
        KeyValueData kvd = new KeyValueData(this.kvdKey(value), value);
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }

    private String kvdKey(AxisStatus value) {
        return this.kvdKey((Serializable)value) + "/" + value.getAxisName();
    }

    final void publish(AxisStatus value) {
        KeyValueData kvd = new KeyValueData(this.kvdKey(value), (Serializable)value);
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }

    private void publishMotionStatus(String axisName, boolean isMoving) {
        AxisStatus oldstat = this.axisStati.get(axisName);
        AxisStatus newstat = new AxisStatus(axisName, oldstat.isEnabled(), isMoving, oldstat.isAtHome(), oldstat.isAtLowLimit(), oldstat.isAtHighLimit(), oldstat.getFaults(), oldstat.getPosition());
        this.axisStati.put(axisName, newstat);
        this.publish(newstat);
    }

    private <T> T completeFuture(CompletableFuture<T> fut, T value) {
        fut.complete(value);
        return value;
    }

    private <T> T getFuture(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (ExecutionException exc) {
            Throwable cause = exc.getCause();
            throw new RuntimeException(cause);
        }
        catch (Throwable exc) {
            throw new RuntimeException(exc);
        }
    }

    static {
        List<String> axes = Arrays.asList("X", "Y", "U", "B", "P");
        List<String> units = Arrays.asList("mm", "mm", "deg", "deg", "deg");
        config = new PlatformConfig(axes, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "CCOB Thin", units);
    }

    private static final class CannedCommand {
        public final CompletableFuture<String> reply;
        public final Callable<String> command;

        public CannedCommand(CompletableFuture<String> reply, Callable<String> command) {
            this.reply = reply;
            this.command = command;
        }
    }
}

