/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.CompoundView;
import org.lsst.ccs.gconsole.plugins.monitor.ConfigView;
import org.lsst.ccs.gconsole.plugins.monitor.LazyTreeView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedGroupView;

public final class DefaultView
extends CompoundView {
    public static final String CREATOR_PATH = "Built-In/Default";
    public static final String CREATOR_PATH_CONF = "Built-In/Default, Configurable";
    private final AbstractMonitorView dataView;
    private final ConfigView controlView;

    @Create(category="MonitorView", name="Default", path="Built-In/Default", description="Default monitoring data view.")
    public DefaultView() {
        this(true, null);
        this.getDescriptor().setName("Default");
    }

    @Create(category="MonitorView", name="Default, Configurable", path="Built-In/Default, Configurable", description="Default monitoring data view, configurable at creation time.")
    public DefaultView(@Par(def="true", desc="Show groups of channels in separate tabs. The filter is assumed to provide display paths in group//rest/of/path format. If no group names are present, no tabs are displayed.") boolean groupTabs, @Par(def="_null_", desc="List of fields to display. If not specified, the set of fields provided by the filter is used. Available standard fields: VALUE, UNITS, LOW_WARN, LOW_ALARM, ALERT_LOW, HIGH_WARN, HIGH_ALARM, ALERT_HIGH, DESCR") List<String> fields) {
        super(new JPanel(new BorderLayout()));
        this.descriptor = new Descriptor();
        this.getDescriptor().setName("Default, Configurable");
        this.dataView = groupTabs ? new TabbedGroupView(0, false) : new LazyTreeView();
        if (fields != null) {
            this.dataView.getDescriptor().setFields(fields.toArray(new String[0]));
        }
        this.addView(this.dataView, CompoundView.Mode.INDEPENDENT);
        this.getPanel().add((Component)this.dataView.getPanel(), "Center");
        this.controlView = new ConfigView();
        this.addView(this.controlView, CompoundView.Mode.INDEPENDENT);
        this.getPanel().add((Component)this.controlView.getPanel(), "South");
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        this.dataView.setFormatter(formatter);
    }

    @Override
    public MonitorFormat getFormater() {
        return this.dataView.getFormater();
    }

    public static class Descriptor
    extends CompoundView.Descriptor {
    }
}

