package org.lsst.ccs.subsystem.ccob.thin.buses;

/**
 * Carries the reply from the TB server when that reply indicates that a command
 * resulted in an error.
 * @author tether
 */
public class TBServerException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    /**
     * Saves the reply from the TB server.
     * @param reply the entire reply that the TB server made to the command that caused the error,
     * stripped of leading and trailing white space.
     */
    public TBServerException(final String reply) {
        super(reply);
    }

}
