/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.ccob.constants.CCOBAgentProperties;
import org.lsst.ccs.subsystem.ccob.data.CCOBState;
import org.lsst.ccs.utilities.logging.Logger;

public class CCOBMainModule
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    private static final Logger LOG = Logger.getLogger((String)CCOBMainModule.class.getName());

    public void postInit() {
        this.subsys.setAgentProperty(CCOBAgentProperties.CCOB_AGENT, CCOBMainModule.class.getCanonicalName());
    }

    public void postStart() {
        LOG.info((Object)"CCOB subsystem started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the CCOB state")
    public CCOBState getFullState() {
        return this.getState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    @Command
    public CCOBDataRead getADCValues() throws DriverException {
        return null;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn On the led.")
    public void turnOnLed() {
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn Off the led.")
    public void turnOffLed() {
    }

    private CCOBState getState() {
        return new CCOBState(this.getTickPeriod());
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("CCOBState", (Serializable)this.getState()));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

