/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystem.ccob;

import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;

/**
 *
 * @author virieux
 */
public class Thermometer implements HasLifecycle {
    
    double temperature;
    
    @LookupName
    private String name;
    
    @LookupField(strategy=Strategy.TOP)
    private Subsystem s;

    @LookupField(strategy = Strategy.TREE)
    private AgentPeriodicTaskService periodicTasks;
    
    public double readTemperature() {
        //TODO write here what to do to read the temperature : read an analog input of an ADC.
        double temp = 0;
        return temp;
    }
    
    public void updateTemperature() {
        temperature = readTemperature();
    }
    
    @Override
    public void build() {
        periodicTasks.scheduleAgentPeriodicTask(new AgentPeriodicTask(name+"-tick", ()->publishData())
        .withPeriod(Duration.ofSeconds(1)));
    }
    
    /**
     * Publish Data on status bus for trending data base and GUIs.
     */
    public void publishData() {
        updateTemperature();
        s.publishSubsystemDataOnStatusBus(new KeyValueData("temperature", temperature));
    }
    
}
