/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.ccob.CCOBSocketDriver;
import org.lsst.ccs.drivers.ccob.CCOBUsb;
import org.lsst.ccs.drivers.ccob.jni.CcobJNI;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CCOBDevice
extends Device {
    public static final int CHAN_LED_VOLTAGE = 0;
    public static final int CHAN_LED_CURRENT = 1;
    public static final int CHAN_LED_VREF = 2;
    public static final int CHAN_LED_TEMP1 = 3;
    public static final int CHAN_LED_TEMP2 = 4;
    public static final int CHAN_PD_CURRENT = 5;
    public static final int CHAN_SPHERE_TEMP = 6;
    public static final int CHAN_BOARD_TEMP = 7;
    public static final int CHAN_PD_ADC = 8;
    public static final int NUM_CHANNELS = 9;
    private static final int CONN_TYPE_USB = 0;
    private static final int CONN_TYPE_SOCKET = 1;
    private static final int CONN_TYPE_JNI = 2;
    private static final int CONN_TYPE_SIM = 3;
    private static final Map<String, Integer> connTypeMap = new HashMap<String, Integer>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private CCOBCommands cmnds;
    private String connType = "usb";
    private String node;
    private int index = 0;
    private int port = 1557;
    private static final Logger LOG;
    private CCOBInterface driver;
    private CCOBDataRead readValues;
    private volatile int failedAttemptsAtClosing = 0;
    private volatile int failedAttemptsAtInitializing = 0;
    private volatile boolean canCallInitDeviceAgain = true;

    protected void initDevice() {
        LOG.info((Object)"Initializing CCOBDevice");
        Integer cType = connTypeMap.get(this.connType.toLowerCase());
        if (cType == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"connType", (String)"is invalid");
        }
        if (cType == 0) {
            this.driver = new CCOBUsb(this.index);
            this.fullName = "CCOB (USB)";
        } else if (cType == 1) {
            if (this.node == null) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"node", (String)"is not specified");
            }
            this.driver = new CCOBSocketDriver(this.node, this.port);
            this.fullName = "CCOB (Socket:" + this.node + ":" + this.port + ")";
        } else {
            this.driver = new CcobJNI();
            this.fullName = "CCOB (JNI)";
        }
        this.cmnds.setDriver(this.driver);
    }

    protected void initialize() {
        if ((this.failedAttemptsAtClosing > 3 || this.failedAttemptsAtInitializing > 3) && this.canCallInitDeviceAgain) {
            this.initDevice();
            this.failedAttemptsAtClosing = 0;
            this.failedAttemptsAtInitializing = 0;
            this.canCallInitDeviceAgain = false;
        }
        try {
            this.driver.init();
            this.setOnline(true);
            LOG.info((Object)("Connected to " + this.fullName));
            this.failedAttemptsAtInitializing = 0;
        }
        catch (DriverException e) {
            ++this.failedAttemptsAtInitializing;
            LOG.log(Level.SEVERE, "Error connecting to " + this.fullName + " (failure:" + this.failedAttemptsAtInitializing + ")", (Throwable)e);
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.driver.stop();
            this.failedAttemptsAtClosing = 0;
        }
        catch (DriverException e) {
            ++this.failedAttemptsAtClosing;
            LOG.log(Level.SEVERE, "Failed attempt at closing device (failure:" + this.failedAttemptsAtClosing + ")", (Throwable)e);
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan >= 9) {
            MonitorLogUtils.reportError((Logger)LOG, (String)this.name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    public void readChannelGroup(String group) {
        if (!this.isOnline()) {
            return;
        }
        if (group.equals("adcValues")) {
            try {
                this.readValues = this.driver.getAdcValues();
            }
            catch (DriverException ex) {
                LOG.error((Object)("Error reading " + this.fullName + " ADC group: " + ex));
                this.setOnline(false);
                this.readValues = null;
            }
        }
    }

    protected String getGroupForChannel(Channel ch) {
        if (ch.getHwChan() != 8) {
            return "adcValues";
        }
        return null;
    }

    public double readChannel(Channel ch) {
        double value = Double.NaN;
        if (this.isOnline()) {
            int hwChan = ch.getHwChan();
            if (hwChan != 8) {
                value = this.readValues != null ? this.readValues.getDoubleArray()[hwChan] : Double.NaN;
            } else {
                try {
                    value = this.driver.getAdcPhotoDiode();
                }
                catch (DriverException ex) {
                    LOG.error((Object)("Error reading " + this.fullName + " phodiode ADC: " + ex));
                    this.setOnline(false);
                }
            }
        }
        return value;
    }

    static {
        connTypeMap.put("usb", 0);
        connTypeMap.put("socket", 1);
        connTypeMap.put("jni", 2);
        LOG = Logger.getLogger((String)CCOBDevice.class.getName());
    }
}

