package org.lsst.ccs.subsystem.ccob;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.ccob.constants.CCOBAgentProperties;
import org.lsst.ccs.subsystem.common.BasicMain;

public class CCOBMainModule extends BasicMain {
    
    private static final Logger LOG = Logger.getLogger(CCOBMainModule.class.getName());

    public CCOBMainModule() {
        super("CCOB system", CCOBAgentProperties.CCOB_AGENT);
        getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    @Override
    public void postStart() {
        LOG.info("CCOB subsystem started");
    }
    
    /**
     *  Gets the ADC values.
     *
     *  @return  The ADC values
     *  @throws  DriverException
     */
    @Command
    public CCOBDataRead getADCValues() {
        // Placeholder for now
        return null;
    }
    
    /**
     * Turn On the led. 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
             description="Turn On the led.")
    public void turnOnLed() {
        // Placeholder for now
    }

    /**
     * Turn Off the led. 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
             description="Turn Off the led.")   
    public void turnOffLed() {
        // Placeholder for now
    }

}
