/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;

public class Maq20PulseControl
implements HasLifecycle,
Maq20Device.Maq20DiscControl {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Maq20Device maqDevc;
    @ConfigurationParameter
    private int pulsesPerRevn = 1;
    private String type;
    private static final Logger LOG = Logger.getLogger(Maq20PulseControl.class.getName());
    private Maq20Device.ModuleData modData;
    private Maq20DiscretePulse pulse;
    private int funcNum;
    private boolean inited = false;

    public void init() {
        String[] words;
        if (this.type == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "type", "not specified");
        }
        if ((words = this.type.split(":")).length != 2) {
            ErrorUtils.reportConfigError(LOG, this.name, "type", "doesn't have exactly two elements");
        }
        try {
            int modIx = Integer.decode(words[0]);
            this.modData = this.maqDevc.getModuleData(modIx);
            if (this.modData == null) {
                ErrorUtils.reportConfigError(LOG, this.name, "module " + modIx, "doesn't exist");
            }
        }
        catch (NumberFormatException ex) {
            ErrorUtils.reportConfigError(LOG, this.name, "module index (" + words[0] + ")", "is not numeric");
        }
        if (!words[1].equals("0") && !words[1].equals("1")) {
            ErrorUtils.reportConfigError(LOG, this.name, "function number (" + words[1] + ")", "is not 0 or 1");
        }
        this.funcNum = Integer.decode(words[1]);
    }

    @Override
    public void initialize() throws DriverException {
        this.pulse = this.modData.maqDiscPulse;
        this.inited = true;
        this.checkPulse();
        this.pulse.enable(this.funcNum);
        this.setPulsesPerRevn(this.pulsesPerRevn);
    }

    @ConfigurationParameterChanger
    public void setPulsesPerRevn(int pulses) throws DriverException {
        this.pulsesPerRevn = pulses;
        if (this.inited) {
            this.checkPulse();
            this.pulse.setPulsesPerRevn(this.funcNum, this.pulsesPerRevn);
            this.pulse.armFunction(this.funcNum);
        }
    }

    @Command(description="Get number of pulses per revolution")
    public int getPulsesPerRevn() {
        return this.pulsesPerRevn;
    }

    private void checkPulse() throws DriverException {
        if (this.pulse == null) {
            throw new DriverException("Cannot access pulse function");
        }
    }
}

