/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;

public class Thermometer
implements HasLifecycle {
    double temperature;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTasks;

    public double readTemperature() {
        double temp = 0.0;
        return temp;
    }

    public void updateTemperature() {
        this.temperature = this.readTemperature();
    }

    public void build() {
        this.periodicTasks.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + "-tick", () -> this.publishData()).withPeriod(Duration.ofSeconds(1L)));
    }

    public void publishData() {
        this.updateTemperature();
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData("temperature", (Serializable)Double.valueOf(this.temperature)));
    }
}

