/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.ccob.Led;
import org.lsst.ccs.subsystem.ccob.Shutter;
import org.lsst.ccs.subsystem.ccob.Thermometer;
import org.lsst.ccs.subsystem.ccob.data.CCOBAgentProperties;
import org.lsst.ccs.subsystem.ccob.data.CCOBFullState;
import org.lsst.ccs.subsystem.ccob.data.CCOBState;
import org.lsst.ccs.utilities.logging.Logger;

public class CCOBMainModule
implements HasLifecycle {
    public static final Logger ccobLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.ccob");
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CCOBCommands driver;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Led led;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Shutter shutter;
    Thermometer thermometer;

    public void postInit() {
        this.subsys.setAgentProperty(CCOBAgentProperties.CCOB_TYPE_AGENT_PROPERTY, CCOBMainModule.class.getCanonicalName());
    }

    public void postStart() {
        ccobLog.info((Object)"CCOB subsystem started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full AuxTest state")
    public CCOBFullState getFullState() {
        return new CCOBFullState(this.getState(), this.subsys.getMonitor().getFullState());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    @Command
    public CCOBDataRead getADCValues() throws DriverException {
        return this.driver.getAdcValues();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn On the led.")
    public void turnOnLed() {
        this.led.turnOn();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn Off the led.")
    public void turnOffLed() {
        this.led.turnOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open the shutter.")
    public void openShutter() {
        this.shutter.open();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the shutter.")
    public void closeShutter() {
        this.shutter.close();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Take an image.")
    public void takeImage() {
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read temperature on the gauge and returns its values in decimal format.")
    public double readTemperature() {
        return this.thermometer.readTemperature();
    }

    private CCOBState getState() {
        return new CCOBState(this.getTickPeriod());
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("CCOBState", (Serializable)this.getState()));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

