
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.ccob.CCOBMainModule;
import org.lsst.ccs.subsystem.ccob.*;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.drivers.ccob.jni.CcobJNI
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["ccob-subsystem"]

builder.
    main (CCOBMainModule, nodeTags:["monitor-update/taskPeriodMillis":2000,"monitor-publish/taskPeriodMillis":2000, "monitor-check/taskPeriodMillis":-1]) {  
    
    // Low level access to driver, via a socket
    ccobDriver(CCOBCommands, driver:new CcobJNI())
//        ccobDriver(CCOBSocketCommands, driver:new CcobSocketDriver("localhost", 1557))
    
    // ------ Monitoring 
    ccobDvc(CCOBDevice) {
        
        // Channels read as a group with getADCValues
        ledVoltage(Channel, hwChan:0, units:"V", format:".5f", type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:5.0, alarmHi:null)
        ledCurrent(Channel, hwChan:1, units:"A", format:".6f", type:"AMPS", subtype:"1A", checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:1.0, alarmHi:null)
        vrefLed(Channel, hwChan:2, units:"V", format:".5f", type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:5.0, alarmHi:null)
        tempLed1(Channel, hwChan:3, units:"\u00b0C", format:".1f", type:"C", subtype:"", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)
        tempLed2(Channel, hwChan:4, units:"\u00b0C", format:".1f", type:"C", subtype:"", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)
        photodiodeCurrent(Channel, hwChan:5, units:"A", format:".6f", type:"AMPS", subtype:"1A", checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:1.0, alarmHi:null)
        tempSphere(Channel, hwChan:6, units:"\u00b0C", format:".1f", type:"C", subtype:"", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)
        tempBrd(Channel, hwChan:7, units:"\u00b0C", format:".1f", type:"C", subtype:"", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)
        
        // Channels read separately
        photodiodeAdc(Channel, hwChan:8, units:"V", format:".5f", type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:5.0, alarmHi:null)
    }

    // ----- Other
    led (Led)
    shutter (Shutter)
}

